/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.binlog.BinlogReadOnlyIncrementalSnapshotContext;
import io.debezium.connector.binlog.gtid.GtidSet;
import io.debezium.connector.mysql.gtid.MySqlGtidSet;
import io.debezium.pipeline.spi.OffsetContext;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlReadOnlyIncrementalSnapshotContext<T>
extends BinlogReadOnlyIncrementalSnapshotContext<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlReadOnlyIncrementalSnapshotContext.class);
    private MySqlGtidSet previousLowWatermark;
    private MySqlGtidSet previousHighWatermark;
    private MySqlGtidSet lowWatermark;
    private MySqlGtidSet highWatermark;

    public MySqlReadOnlyIncrementalSnapshotContext() {
        this(true);
    }

    public MySqlReadOnlyIncrementalSnapshotContext(boolean useCatalogBeforeSchema) {
        super(useCatalogBeforeSchema);
    }

    @Override
    public void setLowWatermark(GtidSet lowWatermark) {
        this.lowWatermark = (MySqlGtidSet)lowWatermark;
    }

    @Override
    public void setHighWatermark(GtidSet highWatermark) {
        this.highWatermark = (MySqlGtidSet)highWatermark.subtract(this.lowWatermark);
    }

    @Override
    public boolean hasServerIdentifierChanged() {
        return this.serverUuidChanged();
    }

    @Override
    public boolean updateWindowState(OffsetContext offsetContext) {
        String currentGtid = this.getCurrentGtid(offsetContext);
        if (!this.windowOpened && this.lowWatermark != null) {
            boolean pastLowWatermark;
            boolean bl = pastLowWatermark = !this.lowWatermark.contains(currentGtid);
            if (pastLowWatermark) {
                LOGGER.debug("Current gtid {}, low watermark {}", (Object)currentGtid, (Object)this.lowWatermark);
                this.windowOpened = true;
            }
        }
        if (this.windowOpened && this.highWatermark != null) {
            boolean pastHighWatermark;
            boolean bl = pastHighWatermark = !this.highWatermark.contains(currentGtid);
            if (pastHighWatermark) {
                LOGGER.debug("Current gtid {}, high watermark {}", (Object)currentGtid, (Object)this.highWatermark);
                this.closeWindow();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean reachedHighWatermark(String currentGtid) {
        long maxTransactionId;
        if (this.highWatermark == null) {
            return false;
        }
        if (currentGtid == null) {
            return true;
        }
        String[] gtid = MySqlGtidSet.GTID_DELIMITER.split(currentGtid);
        MySqlGtidSet.UUIDSet uuidSet = this.getUuidSet(gtid[0]);
        if (uuidSet != null && (maxTransactionId = uuidSet.getIntervals().stream().mapToLong(MySqlGtidSet.Interval::getEnd).max().getAsLong()) <= Long.parseLong(gtid[1])) {
            LOGGER.debug("Gtid {} reached high watermark {}", (Object)currentGtid, (Object)this.highWatermark);
            return true;
        }
        return false;
    }

    @Override
    public void closeWindow() {
        this.windowOpened = false;
        this.previousHighWatermark = this.highWatermark;
        this.highWatermark = null;
        this.previousLowWatermark = this.lowWatermark;
        this.lowWatermark = null;
    }

    @Override
    public boolean watermarksChanged() {
        return !this.previousLowWatermark.equals(this.lowWatermark) || !this.previousHighWatermark.equals(this.highWatermark);
    }

    private MySqlGtidSet.UUIDSet getUuidSet(String serverId) {
        return this.highWatermark.getUUIDSets().isEmpty() ? this.lowWatermark.forServerWithId(serverId) : this.highWatermark.forServerWithId(serverId);
    }

    private boolean serverUuidChanged() {
        return this.highWatermark.getUUIDSets().size() > 1;
    }

    public static <U> MySqlReadOnlyIncrementalSnapshotContext<U> load(Map<String, ?> offsets) {
        return MySqlReadOnlyIncrementalSnapshotContext.load(offsets, true);
    }

    public static <U> MySqlReadOnlyIncrementalSnapshotContext<U> load(Map<String, ?> offsets, boolean useCatalogBeforeSchema) {
        MySqlReadOnlyIncrementalSnapshotContext context = new MySqlReadOnlyIncrementalSnapshotContext(useCatalogBeforeSchema);
        MySqlReadOnlyIncrementalSnapshotContext.init(context, offsets);
        return context;
    }
}

