/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.DebeziumException;
import io.debezium.connector.binlog.BinlogReadOnlyIncrementalSnapshotChangeEventSource;
import io.debezium.connector.binlog.gtid.GtidSet;
import io.debezium.connector.binlog.jdbc.BinlogConnectorConnection;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.MySqlPartition;
import io.debezium.connector.mysql.gtid.MySqlGtidSet;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.relational.TableId;
import io.debezium.schema.DatabaseSchema;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.util.function.Consumer;

public class MySqlReadOnlyIncrementalSnapshotChangeEventSource
extends BinlogReadOnlyIncrementalSnapshotChangeEventSource<MySqlPartition, MySqlOffsetContext> {
    private final BinlogConnectorConnection binlogConnectorConnection;

    public MySqlReadOnlyIncrementalSnapshotChangeEventSource(MySqlConnectorConfig config, BinlogConnectorConnection jdbcConnection, EventDispatcher<MySqlPartition, TableId> dispatcher, DatabaseSchema<?> databaseSchema, Clock clock, SnapshotProgressListener<MySqlPartition> progressListener, DataChangeEventListener<MySqlPartition> dataChangeEventListener, NotificationService<MySqlPartition, MySqlOffsetContext> notificationService) {
        super(config, jdbcConnection, dispatcher, databaseSchema, clock, progressListener, dataChangeEventListener, notificationService);
        this.binlogConnectorConnection = jdbcConnection;
    }

    @Override
    protected void getExecutedGtidSet(Consumer<GtidSet> watermark) {
        try {
            this.jdbcConnection.query(this.binlogConnectorConnection.binaryLogStatusStatement(), rs -> {
                if (rs.next()) {
                    if (rs.getMetaData().getColumnCount() > 4) {
                        String gtidSet = rs.getString(5);
                        watermark.accept(new MySqlGtidSet(gtidSet));
                    } else {
                        throw new UnsupportedOperationException("Need to add support for executed GTIDs for versions prior to 5.6.5");
                    }
                }
            });
            this.jdbcConnection.commit();
        }
        catch (SQLException e) {
            throw new DebeziumException(e);
        }
    }
}

