/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog.event;

import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.deserialization.DeleteRowsEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.UpdateRowsEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.WriteRowsEventDataDeserializer;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import java.io.IOException;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowDeserializers {
    private static final Logger LOGGER = LoggerFactory.getLogger(RowDeserializers.class);
    private static final int MASK_10_BITS = 1023;
    private static final int MASK_6_BITS = 63;

    protected static Serializable deserializeString(int length, ByteArrayInputStream inputStream) throws IOException {
        int stringLength = length < 256 ? inputStream.readInteger(1) : inputStream.readInteger(2);
        return inputStream.read(stringLength);
    }

    protected static Serializable deserializeVarString(int meta, ByteArrayInputStream inputStream) throws IOException {
        int varcharLength = meta < 256 ? inputStream.readInteger(1) : inputStream.readInteger(2);
        return inputStream.read(varcharLength);
    }

    protected static Serializable deserializeDate(ByteArrayInputStream inputStream, CommonConnectorConfig.EventProcessingFailureHandlingMode eventProcessingFailureHandlingMode) throws IOException {
        int value = inputStream.readInteger(3);
        int day = value % 32;
        int month = (value >>>= 5) % 16;
        int year = value >> 4;
        if (year == 0 || month == 0 || day == 0) {
            return null;
        }
        try {
            return LocalDate.of(year, month, day);
        }
        catch (DateTimeException e) {
            return RowDeserializers.handleException(eventProcessingFailureHandlingMode, "date", e, LocalDate.EPOCH);
        }
    }

    protected static Serializable deserializeTime(ByteArrayInputStream inputStream) throws IOException {
        int value = inputStream.readInteger(3);
        int[] split = RowDeserializers.split(value, 100, 3);
        int hours = split[2];
        int minutes = split[1];
        int seconds = split[0];
        return Duration.ofHours(hours).plusMinutes(minutes).plusSeconds(seconds);
    }

    protected static Serializable deserializeTimeV2(int meta, ByteArrayInputStream inputStream) throws IOException {
        boolean is_negative;
        int fractionBytes = (meta + 1) / 2;
        int payloadBytes = 3 + fractionBytes;
        int payloadBits = payloadBytes * 8;
        long time = RowDeserializers.bigEndianLong(inputStream.read(payloadBytes), 0, payloadBytes);
        boolean bl = is_negative = RowDeserializers.bitSlice(time, 0, 1, payloadBits) == 0;
        if (is_negative) {
            time = (time ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
        }
        int hours = RowDeserializers.bitSlice(time, 2, 10, payloadBits);
        int minutes = RowDeserializers.bitSlice(time, 12, 6, payloadBits);
        int seconds = RowDeserializers.bitSlice(time, 18, 6, payloadBits);
        int fraction = RowDeserializers.bitSlice(time, 24, fractionBytes * 8, payloadBits);
        long nanoSeconds = (long)((double)fraction / (1.0E-7 * Math.pow(100.0, fractionBytes - 1)));
        Duration duration = Duration.ofHours(hours).plusMinutes(minutes).plusSeconds(seconds).plusNanos(nanoSeconds);
        return is_negative && !duration.isNegative() ? duration.negated() : duration;
    }

    protected static Serializable deserializeDatetime(ByteArrayInputStream inputStream, CommonConnectorConfig.EventProcessingFailureHandlingMode eventProcessingFailureHandlingMode) throws IOException {
        int[] split = RowDeserializers.split(inputStream.readLong(8), 100, 6);
        int year = split[5];
        int month = split[4];
        int day = split[3];
        int hours = split[2];
        int minutes = split[1];
        int seconds = split[0];
        int nanoOfSecond = 0;
        if (year == 0 || month == 0 || day == 0) {
            return null;
        }
        try {
            return LocalDateTime.of(year, month, day, hours, minutes, seconds, nanoOfSecond);
        }
        catch (DateTimeException e) {
            return RowDeserializers.handleException(eventProcessingFailureHandlingMode, "datetime", e, LocalDateTime.of(LocalDate.EPOCH, LocalTime.MIDNIGHT));
        }
    }

    protected static Serializable deserializeDatetimeV2(int meta, ByteArrayInputStream inputStream, CommonConnectorConfig.EventProcessingFailureHandlingMode eventProcessingFailureHandlingMode) throws IOException {
        long datetime = RowDeserializers.bigEndianLong(inputStream.read(5), 0, 5);
        int yearMonth = RowDeserializers.bitSlice(datetime, 1, 17, 40);
        int year = yearMonth / 13;
        int month = yearMonth % 13;
        int day = RowDeserializers.bitSlice(datetime, 18, 5, 40);
        int hours = RowDeserializers.bitSlice(datetime, 23, 5, 40);
        int minutes = RowDeserializers.bitSlice(datetime, 28, 6, 40);
        int seconds = RowDeserializers.bitSlice(datetime, 34, 6, 40);
        int nanoOfSecond = RowDeserializers.deserializeFractionalSecondsInNanos(meta, inputStream);
        if (year == 0 || month == 0 || day == 0) {
            return null;
        }
        try {
            return LocalDateTime.of(year, month, day, hours, minutes, seconds, nanoOfSecond);
        }
        catch (DateTimeException e) {
            return RowDeserializers.handleException(eventProcessingFailureHandlingMode, "datetimeV2", e, LocalDateTime.of(LocalDate.EPOCH, LocalTime.MIDNIGHT));
        }
    }

    protected static Serializable deserializeTimestamp(ByteArrayInputStream inputStream) throws IOException {
        long epochSecond = inputStream.readLong(4);
        int nanoSeconds = 0;
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(epochSecond, nanoSeconds), ZoneOffset.UTC);
    }

    protected static Serializable deserializeTimestampV2(int meta, ByteArrayInputStream inputStream) throws IOException {
        long epochSecond = RowDeserializers.bigEndianLong(inputStream.read(4), 0, 4);
        int nanoSeconds = RowDeserializers.deserializeFractionalSecondsInNanos(meta, inputStream);
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(epochSecond, nanoSeconds), ZoneOffset.UTC);
    }

    protected static Serializable deserializeYear(ByteArrayInputStream inputStream) throws IOException {
        return Year.of(1900 + inputStream.readInteger(1));
    }

    protected static int[] split(long value, int divider, int length) {
        int[] result = new int[length];
        for (int i = 0; i < length - 1; ++i) {
            result[i] = (int)(value % (long)divider);
            value /= (long)divider;
        }
        result[length - 1] = (int)value;
        return result;
    }

    protected static long bigEndianLong(byte[] bytes, int offset, int length) {
        long result = 0L;
        for (int i = offset; i < offset + length; ++i) {
            int b = bytes[i];
            result = result << 8 | (long)(b >= 0 ? b : b + 256);
        }
        return result;
    }

    protected static int bitSlice(long value, int bitOffset, int numberOfBits, int payloadSize) {
        long result = value >> payloadSize - (bitOffset + numberOfBits);
        return (int)(result & (long)((1 << numberOfBits) - 1));
    }

    protected static int deserializeFractionalSecondsInNanos(int fsp, ByteArrayInputStream inputStream) throws IOException {
        int length = (fsp + 1) / 2;
        if (length > 0) {
            long fraction = RowDeserializers.bigEndianLong(inputStream.read(length), 0, length);
            return (int)((double)fraction / (1.0E-7 * Math.pow(100.0, length - 1)));
        }
        return 0;
    }

    private RowDeserializers() {
    }

    private static Serializable handleException(CommonConnectorConfig.EventProcessingFailureHandlingMode eventProcessingFailureHandlingMode, String columnType, Exception e, Serializable defaultValue) {
        if (eventProcessingFailureHandlingMode == CommonConnectorConfig.EventProcessingFailureHandlingMode.FAIL) {
            LOGGER.error("Error while deserializing binlog data of {}: {}", (Object)columnType, (Object)e.getMessage());
            throw new DebeziumException("Error while deserializing binlog data of " + columnType + ": " + e.getMessage());
        }
        if (eventProcessingFailureHandlingMode == CommonConnectorConfig.EventProcessingFailureHandlingMode.WARN) {
            LOGGER.warn("Error while deserializing binlog data of {}: {}", (Object)columnType, (Object)e.getMessage());
            return defaultValue;
        }
        LOGGER.debug("Error while deserializing binlog data of {}: {}", (Object)columnType, (Object)e.getMessage());
        return defaultValue;
    }

    public static class WriteRowsDeserializer
    extends WriteRowsEventDataDeserializer {
        private CommonConnectorConfig.EventProcessingFailureHandlingMode eventProcessingFailureHandlingMode;

        public WriteRowsDeserializer(Map<Long, TableMapEventData> tableMapEventByTableId, CommonConnectorConfig.EventProcessingFailureHandlingMode eventProcessingFailureHandlingMode) {
            super(tableMapEventByTableId);
            this.eventProcessingFailureHandlingMode = eventProcessingFailureHandlingMode;
        }

        @Override
        protected Serializable deserializeString(int length, ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeString(length, inputStream);
        }

        @Override
        protected Serializable deserializeVarString(int meta, ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeVarString(meta, inputStream);
        }

        @Override
        protected Serializable deserializeDate(ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeDate(inputStream, this.eventProcessingFailureHandlingMode);
        }

        @Override
        protected Serializable deserializeDatetime(ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeDatetime(inputStream, this.eventProcessingFailureHandlingMode);
        }

        @Override
        protected Serializable deserializeDatetimeV2(int meta, ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeDatetimeV2(meta, inputStream, this.eventProcessingFailureHandlingMode);
        }

        @Override
        protected Serializable deserializeTimeV2(int meta, ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeTimeV2(meta, inputStream);
        }

        @Override
        protected Serializable deserializeTime(ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeTime(inputStream);
        }

        @Override
        protected Serializable deserializeTimestamp(ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeTimestamp(inputStream);
        }

        @Override
        protected Serializable deserializeTimestampV2(int meta, ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeTimestampV2(meta, inputStream);
        }

        @Override
        protected Serializable deserializeYear(ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeYear(inputStream);
        }
    }

    public static class UpdateRowsDeserializer
    extends UpdateRowsEventDataDeserializer {
        private CommonConnectorConfig.EventProcessingFailureHandlingMode eventProcessingFailureHandlingMode;

        public UpdateRowsDeserializer(Map<Long, TableMapEventData> tableMapEventByTableId, CommonConnectorConfig.EventProcessingFailureHandlingMode eventProcessingFailureHandlingMode) {
            super(tableMapEventByTableId);
            this.eventProcessingFailureHandlingMode = eventProcessingFailureHandlingMode;
        }

        @Override
        protected Serializable deserializeString(int length, ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeString(length, inputStream);
        }

        @Override
        protected Serializable deserializeVarString(int meta, ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeVarString(meta, inputStream);
        }

        @Override
        protected Serializable deserializeDate(ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeDate(inputStream, this.eventProcessingFailureHandlingMode);
        }

        @Override
        protected Serializable deserializeDatetime(ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeDatetime(inputStream, this.eventProcessingFailureHandlingMode);
        }

        @Override
        protected Serializable deserializeDatetimeV2(int meta, ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeDatetimeV2(meta, inputStream, this.eventProcessingFailureHandlingMode);
        }

        @Override
        protected Serializable deserializeTimeV2(int meta, ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeTimeV2(meta, inputStream);
        }

        @Override
        protected Serializable deserializeTime(ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeTime(inputStream);
        }

        @Override
        protected Serializable deserializeTimestamp(ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeTimestamp(inputStream);
        }

        @Override
        protected Serializable deserializeTimestampV2(int meta, ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeTimestampV2(meta, inputStream);
        }

        @Override
        protected Serializable deserializeYear(ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeYear(inputStream);
        }
    }

    public static class DeleteRowsDeserializer
    extends DeleteRowsEventDataDeserializer {
        private CommonConnectorConfig.EventProcessingFailureHandlingMode eventProcessingFailureHandlingMode;

        public DeleteRowsDeserializer(Map<Long, TableMapEventData> tableMapEventByTableId, CommonConnectorConfig.EventProcessingFailureHandlingMode eventProcessingFailureHandlingMode) {
            super(tableMapEventByTableId);
            this.eventProcessingFailureHandlingMode = eventProcessingFailureHandlingMode;
        }

        @Override
        protected Serializable deserializeString(int length, ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeString(length, inputStream);
        }

        @Override
        protected Serializable deserializeVarString(int meta, ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeVarString(meta, inputStream);
        }

        @Override
        protected Serializable deserializeDate(ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeDate(inputStream, this.eventProcessingFailureHandlingMode);
        }

        @Override
        protected Serializable deserializeDatetime(ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeDatetime(inputStream, this.eventProcessingFailureHandlingMode);
        }

        @Override
        protected Serializable deserializeDatetimeV2(int meta, ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeDatetimeV2(meta, inputStream, this.eventProcessingFailureHandlingMode);
        }

        @Override
        protected Serializable deserializeTimeV2(int meta, ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeTimeV2(meta, inputStream);
        }

        @Override
        protected Serializable deserializeTime(ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeTime(inputStream);
        }

        @Override
        protected Serializable deserializeTimestamp(ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeTimestamp(inputStream);
        }

        @Override
        protected Serializable deserializeTimestampV2(int meta, ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeTimestampV2(meta, inputStream);
        }

        @Override
        protected Serializable deserializeYear(ByteArrayInputStream inputStream) throws IOException {
            return RowDeserializers.deserializeYear(inputStream);
        }
    }
}

