/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.search.suggest.phrase.Laplace;
import org.elasticsearch.search.suggest.phrase.LinearInterpolation;
import org.elasticsearch.search.suggest.phrase.StupidBackoff;
import org.elasticsearch.search.suggest.phrase.WordScorer;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public abstract class SmoothingModel
implements NamedWriteable,
ToXContentFragment {
    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getWriteableName());
        this.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SmoothingModel other = (SmoothingModel)obj;
        return this.doEquals(other);
    }

    public final int hashCode() {
        return this.doHashCode();
    }

    protected abstract int doHashCode();

    public static SmoothingModel fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        SmoothingModel model = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (LinearInterpolation.PARSE_FIELD.match(fieldName, parser.getDeprecationHandler())) {
                    model = LinearInterpolation.fromXContent(parser);
                    continue;
                }
                if (Laplace.PARSE_FIELD.match(fieldName, parser.getDeprecationHandler())) {
                    model = Laplace.fromXContent(parser);
                    continue;
                }
                if (StupidBackoff.PARSE_FIELD.match(fieldName, parser.getDeprecationHandler())) {
                    model = StupidBackoff.fromXContent(parser);
                    continue;
                }
                throw new IllegalArgumentException("suggester[phrase] doesn't support object field [" + fieldName + "]");
            }
            throw new ParsingException(parser.getTokenLocation(), "[smoothing] unknown token [" + (Object)((Object)token) + "] after [" + fieldName + "]", new Object[0]);
        }
        return model;
    }

    public abstract WordScorer.WordScorerFactory buildWordScorerFactory();

    protected abstract boolean doEquals(SmoothingModel var1);

    protected abstract XContentBuilder innerToXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;
}

