/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.function.BiConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.Bits;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.elasticsearch.search.aggregations.bucket.filter.QueryToFilterAdapter;

class DocValuesFieldExistsAdapter
extends QueryToFilterAdapter<DocValuesFieldExistsQuery> {
    private int resultsFromMetadata;

    DocValuesFieldExistsAdapter(IndexSearcher searcher, String key, DocValuesFieldExistsQuery query) {
        super(searcher, key, query);
    }

    @Override
    long count(LeafReaderContext ctx, FiltersAggregator.Counter counter, Bits live) throws IOException {
        if (this.countCanUseMetadata(counter, live) && this.canCountFromMetadata(ctx)) {
            ++this.resultsFromMetadata;
            PointValues points = ctx.reader().getPointValues(((DocValuesFieldExistsQuery)this.query()).getField());
            if (points == null) {
                return 0L;
            }
            return points.getDocCount();
        }
        return super.count(ctx, counter, live);
    }

    private boolean canCountFromMetadata(LeafReaderContext ctx) throws IOException {
        FieldInfo info = ctx.reader().getFieldInfos().fieldInfo(((DocValuesFieldExistsQuery)this.query()).getField());
        if (info == null) {
            return true;
        }
        return info.getPointDimensionCount() > 0;
    }

    @Override
    void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        add.accept("specialized_for", "docvalues_field_exists");
        add.accept("results_from_metadata", this.resultsFromMetadata);
    }
}

