/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.index.fielddata.BooleanScriptDocValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.LeafLongFieldData;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.BooleanFieldScript;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public final class BooleanScriptFieldData
extends IndexNumericFieldData {
    private final String fieldName;
    private final BooleanFieldScript.LeafFactory leafFactory;

    private BooleanScriptFieldData(String fieldName, BooleanFieldScript.LeafFactory leafFactory) {
        this.fieldName = fieldName;
        this.leafFactory = leafFactory;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return CoreValuesSourceType.BOOLEAN;
    }

    @Override
    public BooleanScriptLeafFieldData load(LeafReaderContext context) {
        try {
            return this.loadDirect(context);
        }
        catch (Exception e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
    }

    @Override
    public BooleanScriptLeafFieldData loadDirect(LeafReaderContext context) {
        return new BooleanScriptLeafFieldData(new BooleanScriptDocValues(this.leafFactory.newInstance(context)));
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return IndexNumericFieldData.NumericType.BOOLEAN;
    }

    @Override
    protected boolean sortRequiresCustomComparator() {
        return true;
    }

    public static class BooleanScriptLeafFieldData
    extends LeafLongFieldData {
        private final BooleanScriptDocValues booleanScriptDocValues;

        BooleanScriptLeafFieldData(BooleanScriptDocValues booleanScriptDocValues) {
            super(0L, IndexNumericFieldData.NumericType.BOOLEAN);
            this.booleanScriptDocValues = booleanScriptDocValues;
        }

        @Override
        public SortedNumericDocValues getLongValues() {
            return this.booleanScriptDocValues;
        }

        @Override
        public void close() {
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final BooleanFieldScript.LeafFactory leafFactory;

        public Builder(String name, BooleanFieldScript.LeafFactory leafFactory) {
            this.name = name;
            this.leafFactory = leafFactory;
        }

        public BooleanScriptFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new BooleanScriptFieldData(this.name, this.leafFactory);
        }
    }
}

