/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform.transforms;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.transform.transforms.QueryConfig;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class SourceConfig
implements ToXContentObject {
    public static final ParseField QUERY = new ParseField("query", new String[0]);
    public static final ParseField INDEX = new ParseField("index", new String[0]);
    public static final ConstructingObjectParser<SourceConfig, Void> PARSER = new ConstructingObjectParser("transform_config_source", true, args -> {
        String[] index = ((List)args[0]).toArray(new String[0]);
        QueryConfig queryConfig = (QueryConfig)args[1];
        Map runtimeMappings = (Map)args[2];
        return new SourceConfig(index, queryConfig, runtimeMappings);
    });
    private final String[] index;
    private final QueryConfig queryConfig;
    private final Map<String, Object> runtimeMappings;

    public SourceConfig(String ... index) {
        this(index, (QueryConfig)null, (Map<String, Object>)null);
    }

    SourceConfig(String[] index, QueryConfig queryConfig, Map<String, Object> runtimeMappings) {
        this.index = index;
        this.queryConfig = queryConfig;
        this.runtimeMappings = runtimeMappings;
    }

    public String[] getIndex() {
        return this.index;
    }

    public QueryConfig getQueryConfig() {
        return this.queryConfig;
    }

    public Map<String, Object> getRuntimeMappings() {
        return this.runtimeMappings;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.index != null) {
            builder.array(INDEX.getPreferredName(), this.index);
        }
        if (this.queryConfig != null) {
            builder.field(QUERY.getPreferredName(), this.queryConfig);
        }
        if (this.runtimeMappings != null) {
            builder.field(SearchSourceBuilder.RUNTIME_MAPPINGS_FIELD.getPreferredName(), this.runtimeMappings);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        SourceConfig that = (SourceConfig)other;
        return Arrays.equals(this.index, that.index) && Objects.equals(this.queryConfig, that.queryConfig) && Objects.equals(this.runtimeMappings, that.runtimeMappings);
    }

    public int hashCode() {
        int indexArrayHash = Arrays.hashCode(this.index);
        return Objects.hash(indexArrayHash, this.queryConfig, this.runtimeMappings);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), INDEX);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> QueryConfig.fromXContent(p), QUERY);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), SearchSourceBuilder.RUNTIME_MAPPINGS_FIELD);
    }

    public static class Builder {
        private String[] index;
        private QueryConfig queryConfig;
        private Map<String, Object> runtimeMappings;

        public Builder setIndex(String ... index) {
            this.index = index;
            return this;
        }

        public Builder setQueryConfig(QueryConfig queryConfig) {
            this.queryConfig = queryConfig;
            return this;
        }

        public Builder setQuery(QueryBuilder query) {
            return this.setQueryConfig(new QueryConfig(query));
        }

        public Builder setRuntimeMappings(Map<String, Object> runtimeMappings) {
            this.runtimeMappings = runtimeMappings;
            return this;
        }

        public SourceConfig build() {
            return new SourceConfig(this.index, this.queryConfig, this.runtimeMappings);
        }
    }
}

