/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.client.NodesResponseHeader;
import org.elasticsearch.client.security.support.ServiceTokenInfo;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.List;
import org.elasticsearch.xcontent.XContentParser;

public class ServiceAccountCredentialsNodesResponse {
    private final NodesResponseHeader header;
    private final java.util.List<ServiceTokenInfo> fileTokenInfos;

    public ServiceAccountCredentialsNodesResponse(NodesResponseHeader header, java.util.List<ServiceTokenInfo> fileTokenInfos) {
        this.header = header;
        this.fileTokenInfos = fileTokenInfos;
    }

    public NodesResponseHeader getHeader() {
        return this.header;
    }

    public java.util.List<ServiceTokenInfo> getFileTokenInfos() {
        return this.fileTokenInfos;
    }

    public static ServiceAccountCredentialsNodesResponse fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        NodesResponseHeader header = null;
        java.util.List<ServiceTokenInfo> fileTokenInfos = List.of();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
            if ("_nodes".equals(parser.currentName())) {
                if (header == null) {
                    header = NodesResponseHeader.fromXContent(parser, null);
                    continue;
                }
                throw new IllegalArgumentException("expecting only a single [_nodes] field, multiple found");
            }
            if ("file_tokens".equals(parser.currentName())) {
                fileTokenInfos = ServiceAccountCredentialsNodesResponse.parseFileToken(parser);
                continue;
            }
            throw new IllegalArgumentException("expecting field of either [_nodes] or [file_tokens], found [" + parser.currentName() + "]");
        }
        return new ServiceAccountCredentialsNodesResponse(header, fileTokenInfos);
    }

    static java.util.List<ServiceTokenInfo> parseFileToken(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        ArrayList<ServiceTokenInfo> fileTokenInfos = new ArrayList<ServiceTokenInfo>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
            String tokenName = parser.currentName();
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
            XContentParserUtils.ensureFieldName(parser, parser.nextToken(), "nodes");
            parser.nextToken();
            java.util.List<String> nodeNames = XContentParserUtils.parseList(parser, XContentParser::text);
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.nextToken(), parser);
            fileTokenInfos.add(new ServiceTokenInfo(tokenName, "file", nodeNames));
        }
        return fileTokenInfos;
    }
}

