/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.searchafter.SearchAfterBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public final class QueryApiKeyRequest
implements Validatable,
ToXContentObject {
    @Nullable
    private QueryBuilder queryBuilder;
    private Integer from;
    private Integer size;
    @Nullable
    private List<FieldSortBuilder> fieldSortBuilders;
    @Nullable
    private SearchAfterBuilder searchAfterBuilder;

    public QueryApiKeyRequest() {
        this(null, null, null, null, null);
    }

    public QueryApiKeyRequest(@Nullable QueryBuilder queryBuilder, @Nullable Integer from, @Nullable Integer size, @Nullable List<FieldSortBuilder> fieldSortBuilders, @Nullable SearchAfterBuilder searchAfterBuilder) {
        this.queryBuilder = queryBuilder;
        this.from = from;
        this.size = size;
        this.fieldSortBuilders = fieldSortBuilders;
        this.searchAfterBuilder = searchAfterBuilder;
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public int getFrom() {
        return this.from;
    }

    public int getSize() {
        return this.size;
    }

    public List<FieldSortBuilder> getFieldSortBuilders() {
        return this.fieldSortBuilders;
    }

    public SearchAfterBuilder getSearchAfterBuilder() {
        return this.searchAfterBuilder;
    }

    public QueryApiKeyRequest queryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
        return this;
    }

    public QueryApiKeyRequest from(int from) {
        this.from = from;
        return this;
    }

    public QueryApiKeyRequest size(int size) {
        this.size = size;
        return this;
    }

    public QueryApiKeyRequest fieldSortBuilders(List<FieldSortBuilder> fieldSortBuilders) {
        this.fieldSortBuilders = fieldSortBuilders;
        return this;
    }

    public QueryApiKeyRequest searchAfterBuilder(SearchAfterBuilder searchAfterBuilder) {
        this.searchAfterBuilder = searchAfterBuilder;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.queryBuilder != null) {
            builder.field("query");
            this.queryBuilder.toXContent(builder, params);
        }
        if (this.from != null) {
            builder.field("from", this.from);
        }
        if (this.size != null) {
            builder.field("size", this.size);
        }
        if (this.fieldSortBuilders != null && !this.fieldSortBuilders.isEmpty()) {
            builder.field("sort", this.fieldSortBuilders);
        }
        if (this.searchAfterBuilder != null) {
            builder.array(SearchAfterBuilder.SEARCH_AFTER.getPreferredName(), this.searchAfterBuilder.getSortValues());
        }
        return builder.endObject();
    }

    @Override
    public Optional<ValidationException> validate() {
        ValidationException validationException = null;
        if (this.from != null && this.from < 0) {
            validationException = this.addValidationError(validationException, "from must be non-negative");
        }
        if (this.size != null && this.size < 0) {
            validationException = this.addValidationError(validationException, "size must be non-negative");
        }
        return validationException == null ? Optional.empty() : Optional.of(validationException);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryApiKeyRequest that = (QueryApiKeyRequest)o;
        return Objects.equals(this.queryBuilder, that.queryBuilder) && Objects.equals(this.from, that.from) && Objects.equals(this.size, that.size) && Objects.equals(this.fieldSortBuilders, that.fieldSortBuilders) && Objects.equals(this.searchAfterBuilder, that.searchAfterBuilder);
    }

    public int hashCode() {
        return Objects.hash(this.queryBuilder, this.from, this.size, this.fieldSortBuilders, this.searchAfterBuilder);
    }

    private ValidationException addValidationError(ValidationException validationException, String message) {
        if (validationException == null) {
            validationException = new ValidationException();
        }
        validationException.addValidationError(message);
        return validationException;
    }
}

