/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.inference.results;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;

public class FeatureImportance
implements ToXContentObject {
    public static final String IMPORTANCE = "importance";
    public static final String FEATURE_NAME = "feature_name";
    public static final String CLASSES = "classes";
    private static final ConstructingObjectParser<FeatureImportance, Void> PARSER = new ConstructingObjectParser("feature_importance", true, a -> new FeatureImportance((String)a[0], (Double)a[1], (List)a[2]));
    private final List<ClassImportance> classImportance;
    private final Double importance;
    private final String featureName;

    public static FeatureImportance fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public FeatureImportance(String featureName, Double importance, List<ClassImportance> classImportance) {
        this.featureName = Objects.requireNonNull(featureName);
        this.importance = importance;
        this.classImportance = classImportance == null ? null : Collections.unmodifiableList(classImportance);
    }

    public List<ClassImportance> getClassImportance() {
        return this.classImportance;
    }

    public Double getImportance() {
        return this.importance;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FEATURE_NAME, this.featureName);
        if (this.importance != null) {
            builder.field(IMPORTANCE, this.importance);
        }
        if (this.classImportance != null && !this.classImportance.isEmpty()) {
            builder.field(CLASSES, this.classImportance);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FeatureImportance that = (FeatureImportance)object;
        return Objects.equals(this.featureName, that.featureName) && Objects.equals(this.importance, that.importance) && Objects.equals(this.classImportance, that.classImportance);
    }

    public int hashCode() {
        return Objects.hash(this.featureName, this.importance, this.classImportance);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(FEATURE_NAME, new String[0]));
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), new ParseField(IMPORTANCE, new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ClassImportance.fromXContent(p), new ParseField(CLASSES, new String[0]));
    }

    public static class ClassImportance
    implements ToXContentObject {
        static final String CLASS_NAME = "class_name";
        private static final ConstructingObjectParser<ClassImportance, Void> PARSER = new ConstructingObjectParser("feature_importance_class_importance", true, a -> new ClassImportance(a[0], (Double)a[1]));
        private final Object className;
        private final double importance;

        public static ClassImportance fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        public ClassImportance(Object className, double importance) {
            this.className = className;
            this.importance = importance;
        }

        public Object getClassName() {
            return this.className;
        }

        public double getImportance() {
            return this.importance;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(CLASS_NAME, this.className);
            builder.field(FeatureImportance.IMPORTANCE, this.importance);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassImportance that = (ClassImportance)o;
            return Double.compare(that.importance, this.importance) == 0 && Objects.equals(this.className, that.className);
        }

        public int hashCode() {
            return Objects.hash(this.className, this.importance);
        }

        static {
            PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return p.text();
                }
                if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                    return p.numberValue();
                }
                if (p.currentToken() == XContentParser.Token.VALUE_BOOLEAN) {
                    return Boolean.valueOf(p.booleanValue());
                }
                throw new XContentParseException("Unsupported token [" + (Object)((Object)p.currentToken()) + "]");
            }, new ParseField(CLASS_NAME, new String[0]), ObjectParser.ValueType.VALUE);
            PARSER.declareDouble(ConstructingObjectParser.constructorArg(), new ParseField(FeatureImportance.IMPORTANCE, new String[0]));
        }
    }
}

