/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.inject.internal.ToStringBuilder;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class PhaseProgress
implements ToXContentObject {
    static final ParseField PHASE = new ParseField("phase", new String[0]);
    static final ParseField PROGRESS_PERCENT = new ParseField("progress_percent", new String[0]);
    public static final ConstructingObjectParser<PhaseProgress, Void> PARSER = new ConstructingObjectParser("phase_progress", true, a -> new PhaseProgress((String)a[0], (Integer)a[1]));
    private final String phase;
    private final int progressPercent;

    public PhaseProgress(String phase, int progressPercent) {
        this.phase = Objects.requireNonNull(phase);
        this.progressPercent = progressPercent;
    }

    public String getPhase() {
        return this.phase;
    }

    public int getProgressPercent() {
        return this.progressPercent;
    }

    public int hashCode() {
        return Objects.hash(this.phase, this.progressPercent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhaseProgress that = (PhaseProgress)o;
        return Objects.equals(this.phase, that.phase) && this.progressPercent == that.progressPercent;
    }

    public String toString() {
        return new ToStringBuilder(this.getClass()).add(PHASE.getPreferredName(), this.phase).add(PROGRESS_PERCENT.getPreferredName(), this.progressPercent).toString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(PHASE.getPreferredName(), this.phase);
        builder.field(PROGRESS_PERCENT.getPreferredName(), this.progressPercent);
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), PHASE);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), PROGRESS_PERCENT);
    }
}

