/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.migration;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class GetFeatureUpgradeStatusResponse {
    private static final ParseField FEATURE_UPGRADE_STATUSES = new ParseField("features", new String[0]);
    private static final ParseField UPGRADE_STATUS = new ParseField("migration_status", new String[0]);
    private final List<FeatureUpgradeStatus> featureUpgradeStatuses;
    private final String upgradeStatus;
    private static final ConstructingObjectParser<GetFeatureUpgradeStatusResponse, Void> PARSER = new ConstructingObjectParser<GetFeatureUpgradeStatusResponse, Void>("get_feature_upgrade_response", true, (a, ctx) -> new GetFeatureUpgradeStatusResponse((List)a[0], (String)a[1]));

    public GetFeatureUpgradeStatusResponse(List<FeatureUpgradeStatus> featureUpgradeStatuses, String upgradeStatus) {
        this.featureUpgradeStatuses = Objects.nonNull(featureUpgradeStatuses) ? featureUpgradeStatuses : Collections.emptyList();
        this.upgradeStatus = upgradeStatus;
    }

    public static GetFeatureUpgradeStatusResponse parse(XContentParser parser) throws IOException {
        return PARSER.apply(parser, null);
    }

    public List<FeatureUpgradeStatus> getFeatureUpgradeStatuses() {
        return this.featureUpgradeStatuses;
    }

    public String getUpgradeStatus() {
        return this.upgradeStatus;
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), FeatureUpgradeStatus::parse, FEATURE_UPGRADE_STATUSES);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> p.text(), UPGRADE_STATUS, ObjectParser.ValueType.STRING);
    }

    public static class IndexVersion {
        private final String indexName;
        private final String version;
        private static final ParseField INDEX_NAME = new ParseField("index", new String[0]);
        private static final ParseField VERSION = new ParseField("version", new String[0]);
        private static final ConstructingObjectParser<IndexVersion, Void> PARSER = new ConstructingObjectParser<IndexVersion, Void>("index_version", true, (a, ctx) -> new IndexVersion((String)a[0], (String)a[1]));

        public IndexVersion(String indexName, String version) {
            this.indexName = indexName;
            this.version = version;
        }

        public static IndexVersion parse(XContentParser parser, Void ctx) {
            return PARSER.apply(parser, ctx);
        }

        public String getIndexName() {
            return this.indexName;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexVersion that = (IndexVersion)o;
            return Objects.equals(this.indexName, that.indexName) && Objects.equals(this.version, that.version);
        }

        public int hashCode() {
            return Objects.hash(this.indexName, this.version);
        }

        static {
            PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> p.text(), INDEX_NAME, ObjectParser.ValueType.STRING);
            PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> p.text(), VERSION, ObjectParser.ValueType.STRING);
        }
    }

    public static class FeatureUpgradeStatus {
        private final String featureName;
        private final String minimumIndexVersion;
        private final String upgradeStatus;
        private final List<IndexVersion> indexVersions;
        private static final ParseField FEATURE_NAME = new ParseField("feature_name", new String[0]);
        private static final ParseField MINIMUM_INDEX_VERSION = new ParseField("minimum_index_version", new String[0]);
        private static final ParseField UPGRADE_STATUS = new ParseField("migration_status", new String[0]);
        private static final ParseField INDEX_VERSIONS = new ParseField("indices", new String[0]);
        private static final ConstructingObjectParser<FeatureUpgradeStatus, Void> PARSER = new ConstructingObjectParser<FeatureUpgradeStatus, Void>("feature_upgrade_status", true, (a, ctx) -> new FeatureUpgradeStatus((String)a[0], (String)a[1], (String)a[2], (List)a[3]));

        public FeatureUpgradeStatus(String featureName, String minimumIndexVersion, String upgradeStatus, List<IndexVersion> indexVersions) {
            this.featureName = featureName;
            this.minimumIndexVersion = minimumIndexVersion;
            this.upgradeStatus = upgradeStatus;
            this.indexVersions = indexVersions;
        }

        public static FeatureUpgradeStatus parse(XContentParser parser, Void ctx) {
            return PARSER.apply(parser, null);
        }

        public String getFeatureName() {
            return this.featureName;
        }

        public String getMinimumIndexVersion() {
            return this.minimumIndexVersion;
        }

        public String getUpgradeStatus() {
            return this.upgradeStatus;
        }

        public List<IndexVersion> getIndexVersions() {
            return this.indexVersions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeatureUpgradeStatus that = (FeatureUpgradeStatus)o;
            return Objects.equals(this.featureName, that.featureName) && Objects.equals(this.minimumIndexVersion, that.minimumIndexVersion) && Objects.equals(this.upgradeStatus, that.upgradeStatus) && Objects.equals(this.indexVersions, that.indexVersions);
        }

        public int hashCode() {
            return Objects.hash(this.featureName, this.minimumIndexVersion, this.upgradeStatus, this.indexVersions);
        }

        static {
            PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> p.text(), FEATURE_NAME, ObjectParser.ValueType.STRING);
            PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> p.text(), MINIMUM_INDEX_VERSION, ObjectParser.ValueType.STRING);
            PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> p.text(), UPGRADE_STATUS, ObjectParser.ValueType.STRING);
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), IndexVersion::parse, INDEX_VERSIONS);
        }
    }
}

