/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.license;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;

public class StartTrialResponse {
    private static final ConstructingObjectParser<StartTrialResponse, Void> PARSER = new ConstructingObjectParser<StartTrialResponse, Void>("start_trial_response", true, (arguments, aVoid) -> {
        Map acknowledgeMessages;
        String acknowledgeHeader;
        boolean acknowledged = (Boolean)arguments[0];
        boolean trialWasStarted = (Boolean)arguments[1];
        String licenseType = (String)arguments[2];
        String errorMessage = (String)arguments[3];
        Tuple acknowledgeDetails = (Tuple)arguments[4];
        if (acknowledgeDetails != null) {
            acknowledgeHeader = (String)acknowledgeDetails.v1();
            acknowledgeMessages = (Map)acknowledgeDetails.v2();
        } else {
            acknowledgeHeader = null;
            acknowledgeMessages = null;
        }
        return new StartTrialResponse(acknowledged, trialWasStarted, licenseType, errorMessage, acknowledgeHeader, acknowledgeMessages);
    });
    private final boolean acknowledged;
    private final boolean trialWasStarted;
    private final String licenseType;
    private final String errorMessage;
    private final String acknowledgeHeader;
    private final Map<String, String[]> acknowledgeMessages;

    public static StartTrialResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.apply(parser, null);
    }

    public StartTrialResponse(boolean acknowledged, boolean trialWasStarted, String licenseType, String errorMessage, String acknowledgeHeader, Map<String, String[]> acknowledgeMessages) {
        this.acknowledged = acknowledged;
        this.trialWasStarted = trialWasStarted;
        this.licenseType = licenseType;
        this.errorMessage = errorMessage;
        this.acknowledgeHeader = acknowledgeHeader;
        this.acknowledgeMessages = acknowledgeMessages;
    }

    public boolean isAcknowledged() {
        return this.acknowledged;
    }

    public boolean isTrialWasStarted() {
        return this.trialWasStarted;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getAcknowledgeHeader() {
        return this.acknowledgeHeader;
    }

    public Map<String, String[]> getAcknowledgeMessages() {
        return this.acknowledgeMessages;
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("acknowledged", new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("trial_was_started", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("type", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("error_message", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (parser, aVoid) -> {
            HashMap<String, String[]> acknowledgeMessages = new HashMap<String, String[]>();
            String message = null;
            Map<String, Object> parsedMap = parser.map();
            for (Map.Entry<String, Object> entry : parsedMap.entrySet()) {
                if (entry.getKey().equals("message")) {
                    if (entry.getValue() instanceof String) {
                        message = (String)entry.getValue();
                        continue;
                    }
                    throw new XContentParseException(parser.getTokenLocation(), "unexpected acknowledgement header type");
                }
                if (entry.getValue() instanceof List) {
                    ArrayList<String> messageStrings = new ArrayList<String>();
                    List messageObjects = (List)entry.getValue();
                    for (Object messageObject : messageObjects) {
                        if (messageObject instanceof String) {
                            messageStrings.add((String)messageObject);
                            continue;
                        }
                        throw new XContentParseException(parser.getTokenLocation(), "expected text in acknowledgement message");
                    }
                    acknowledgeMessages.put(entry.getKey(), messageStrings.toArray(new String[messageStrings.size()]));
                    continue;
                }
                throw new XContentParseException(parser.getTokenLocation(), "unexpected acknowledgement message type");
            }
            if (message == null) {
                throw new XContentParseException(parser.getTokenLocation(), "expected acknowledgement header");
            }
            return new Tuple(message, acknowledgeMessages);
        }, new ParseField("acknowledge", new String[0]));
    }
}

