/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.document;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.suggest.BitsProducer;
import org.apache.lucene.search.suggest.document.CompletionQuery;
import org.apache.lucene.search.suggest.document.CompletionTokenStream;
import org.apache.lucene.search.suggest.document.CompletionWeight;
import org.apache.lucene.search.suggest.document.PrefixCompletionQuery;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.FiniteStringsIterator;
import org.apache.lucene.util.automaton.LevenshteinAutomata;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.UTF32ToUTF8;

public class FuzzyCompletionQuery
extends PrefixCompletionQuery {
    public static final boolean DEFAULT_UNICODE_AWARE = false;
    public static final int DEFAULT_MIN_FUZZY_LENGTH = 3;
    public static final int DEFAULT_NON_FUZZY_PREFIX = 1;
    public static final int DEFAULT_MAX_EDITS = 1;
    public static final boolean DEFAULT_TRANSPOSITIONS = true;
    private final int maxEdits;
    private final boolean transpositions;
    private final int nonFuzzyPrefix;
    private final int minFuzzyLength;
    private final boolean unicodeAware;
    private final int determinizeWorkLimit;

    public FuzzyCompletionQuery(Analyzer analyzer, Term term) {
        this(analyzer, term, null);
    }

    public FuzzyCompletionQuery(Analyzer analyzer, Term term, BitsProducer filter) {
        this(analyzer, term, filter, 1, true, 1, 3, false, 10000);
    }

    public FuzzyCompletionQuery(Analyzer analyzer, Term term, BitsProducer filter, int maxEdits, boolean transpositions, int nonFuzzyPrefix, int minFuzzyLength, boolean unicodeAware, int determinizeWorkLimit) {
        super(analyzer, term, filter);
        this.maxEdits = maxEdits;
        this.transpositions = transpositions;
        this.nonFuzzyPrefix = nonFuzzyPrefix;
        this.minFuzzyLength = minFuzzyLength;
        this.unicodeAware = unicodeAware;
        this.determinizeWorkLimit = determinizeWorkLimit;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        Automaton originalAutomata;
        try (CompletionTokenStream stream = (CompletionTokenStream)this.analyzer.tokenStream(this.getField(), this.getTerm().text());){
            originalAutomata = stream.toAutomaton(this.unicodeAware);
        }
        HashSet<IntsRef> refs = new HashSet<IntsRef>();
        Automaton automaton = this.toLevenshteinAutomata(originalAutomata, refs);
        if (this.unicodeAware) {
            Automaton utf8automaton = new UTF32ToUTF8().convert(automaton);
            automaton = utf8automaton = Operations.determinize(utf8automaton, this.determinizeWorkLimit);
        }
        return new FuzzyCompletionWeight(this, automaton, refs);
    }

    private Automaton toLevenshteinAutomata(Automaton automaton, Set<IntsRef> refs) {
        IntsRef string;
        ArrayList<Automaton> subs = new ArrayList<Automaton>();
        FiniteStringsIterator finiteStrings = new FiniteStringsIterator(automaton);
        while ((string = finiteStrings.next()) != null) {
            refs.add(IntsRef.deepCopyOf(string));
            if (string.length <= this.nonFuzzyPrefix || string.length < this.minFuzzyLength) {
                subs.add(Automata.makeString(string.ints, string.offset, string.length));
                continue;
            }
            int[] ints = new int[string.length - this.nonFuzzyPrefix];
            System.arraycopy(string.ints, string.offset + this.nonFuzzyPrefix, ints, 0, ints.length);
            LevenshteinAutomata lev = new LevenshteinAutomata(ints, this.unicodeAware ? 0x10FFFF : 255, this.transpositions);
            subs.add(lev.toAutomaton(this.maxEdits, UnicodeUtil.newString(string.ints, string.offset, this.nonFuzzyPrefix)));
        }
        if (subs.isEmpty()) {
            return Automata.makeEmpty();
        }
        if (subs.size() == 1) {
            return (Automaton)subs.get(0);
        }
        Automaton a = Operations.union(subs);
        return Operations.determinize(a, this.determinizeWorkLimit);
    }

    public int getMaxEdits() {
        return this.maxEdits;
    }

    public boolean isTranspositions() {
        return this.transpositions;
    }

    public int getNonFuzzyPrefix() {
        return this.nonFuzzyPrefix;
    }

    public int getMinFuzzyLength() {
        return this.minFuzzyLength;
    }

    public boolean isUnicodeAware() {
        return this.unicodeAware;
    }

    public int getDeterminizeWorkLimit() {
        return this.determinizeWorkLimit;
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.getField().equals(field)) {
            buffer.append(this.getField());
            buffer.append(":");
        }
        buffer.append(this.getTerm().text());
        buffer.append('*');
        buffer.append('~');
        buffer.append(Integer.toString(this.maxEdits));
        if (this.getFilter() != null) {
            buffer.append(",");
            buffer.append("filter");
            buffer.append(this.getFilter().toString());
        }
        return buffer.toString();
    }

    private static class FuzzyCompletionWeight
    extends CompletionWeight {
        private final Set<IntsRef> refs;
        int currentBoost = 0;

        public FuzzyCompletionWeight(CompletionQuery query, Automaton automaton, Set<IntsRef> refs) throws IOException {
            super(query, automaton);
            this.refs = refs;
        }

        @Override
        protected void setNextMatch(IntsRef pathPrefix) {
            int maxCount = 0;
            for (IntsRef ref : this.refs) {
                int minLength = Math.min(ref.length, pathPrefix.length);
                int count = 0;
                for (int i = 0; i < minLength && ref.ints[i + ref.offset] == pathPrefix.ints[i + pathPrefix.offset]; ++i) {
                    ++count;
                }
                maxCount = Math.max(maxCount, count);
            }
            this.currentBoost = maxCount;
        }

        @Override
        protected float boost() {
            return this.currentBoost;
        }
    }
}

