/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.elastic.impl;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.elastic.impl.ElasticSourceConfiguration;
import com.hazelcast.jet.elastic.impl.RetryUtils;
import com.hazelcast.jet.elastic.impl.Shard;
import com.hazelcast.logging.ILogger;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.http.HttpHost;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.slice.SliceBuilder;

final class ElasticSourceP<T>
extends AbstractProcessor {
    private final ElasticSourceConfiguration<T> configuration;
    private final List<Shard> shards;
    private RestHighLevelClient client;
    private ILogger logger;
    private Traverser<T> traverser;
    private ElasticScrollTraverser scrollTraverser;

    ElasticSourceP(ElasticSourceConfiguration<T> configuration, List<Shard> shards) {
        this.configuration = configuration;
        this.shards = shards;
    }

    protected void init(@Nonnull Processor.Context context) throws Exception {
        super.init(context);
        this.logger = context.logger();
        this.logger.fine("init");
        this.client = (RestHighLevelClient)this.configuration.clientFn().get();
        SearchRequest sr = (SearchRequest)this.configuration.searchRequestFn().get();
        sr.scroll(this.configuration.scrollKeepAlive());
        if (this.configuration.isSlicingEnabled()) {
            if (this.configuration.isCoLocatedReadingEnabled()) {
                sliceId = context.localProcessorIndex();
                totalSlices = context.localParallelism();
                if (totalSlices > 1) {
                    this.logger.fine("Slice id=%s, max=%s", (Object)sliceId, (Object)totalSlices);
                    sr.source().slice(new SliceBuilder(sliceId, totalSlices));
                }
            } else {
                sliceId = context.globalProcessorIndex();
                totalSlices = context.totalParallelism();
                if (totalSlices > 1) {
                    this.logger.fine("Slice id=%s, max=%s", (Object)sliceId, (Object)totalSlices);
                    sr.source().slice(new SliceBuilder(sliceId, totalSlices));
                }
            }
        }
        if (this.configuration.isCoLocatedReadingEnabled()) {
            this.logger.fine("Assigned shards: %s", this.shards);
            if (this.shards.isEmpty()) {
                this.traverser = Traversers.empty();
                return;
            }
            Node node = this.createLocalElasticNode();
            this.client.getLowLevelClient().setNodes(Collections.singleton(node));
            String preference = "_shards:" + this.shards.stream().map(shard -> String.valueOf(shard.getShard())).collect(Collectors.joining(",")) + "|_only_local";
            sr.preference(preference);
        }
        this.scrollTraverser = new ElasticScrollTraverser(this.configuration, this.client, sr, this.logger);
        this.traverser = this.scrollTraverser.map((Function)this.configuration.mapToItemFn());
    }

    private Node createLocalElasticNode() {
        List ips = this.shards.stream().map(Shard::getHttpAddress).distinct().collect(Collectors.toList());
        if (ips.size() != 1) {
            throw new JetException("Should receive shards from single local node, got: " + String.valueOf(ips));
        }
        String localIp = (String)ips.get(0);
        return new Node(HttpHost.create(localIp));
    }

    public boolean isCooperative() {
        return false;
    }

    public boolean complete() {
        return this.emitFromTraverser(this.traverser);
    }

    public void close() {
        if (this.scrollTraverser != null) {
            this.scrollTraverser.close();
        }
        try {
            this.client.close();
        }
        catch (Exception e) {
            this.logger.fine("Could not close client", (Throwable)e);
        }
    }

    static class ElasticScrollTraverser
    implements Traverser<SearchHit> {
        private final ILogger logger;
        private final RestHighLevelClient client;
        private final FunctionEx<? super ActionRequest, RequestOptions> optionsFn;
        private final String scrollKeepAlive;
        private final int retries;
        private SearchHits hits;
        private int nextHit;
        private String scrollId;

        ElasticScrollTraverser(ElasticSourceConfiguration<?> configuration, RestHighLevelClient client, SearchRequest sr, ILogger logger) {
            this.client = client;
            this.optionsFn = configuration.optionsFn();
            this.scrollKeepAlive = configuration.scrollKeepAlive();
            this.retries = configuration.retries();
            this.logger = logger;
            try {
                RequestOptions options = (RequestOptions)this.optionsFn.apply((Object)sr);
                SearchResponse response = RetryUtils.withRetry(() -> client.search(sr, options), this.retries);
                this.hits = Objects.requireNonNull(response.getHits(), "null hits in the response");
                this.scrollId = response.getScrollId();
                if (this.scrollId == null && this.hits.getHits().length > 0) {
                    throw new IllegalStateException("Unexpected response: returned scrollId is null, but hits.length is not zero (" + this.hits.getHits().length + "). Please file a bug.");
                }
                TotalHits totalHits = this.hits.getTotalHits();
                if (totalHits != null) {
                    logger.fine("Initialized scroll with scrollId " + this.scrollId + ", total results " + String.valueOf((Object)totalHits.relation) + ", " + totalHits.value);
                }
            }
            catch (Exception e) {
                throw new JetException("Could not execute SearchRequest to Elastic", (Throwable)e);
            }
        }

        public SearchHit next() {
            if (this.hits.getHits().length == 0) {
                this.scrollId = null;
                return null;
            }
            if (this.nextHit >= this.hits.getHits().length) {
                try {
                    SearchScrollRequest ssr = new SearchScrollRequest(this.scrollId);
                    ssr.scroll(this.scrollKeepAlive);
                    SearchResponse searchResponse = RetryUtils.withRetry(() -> this.client.scroll(ssr, (RequestOptions)this.optionsFn.apply((Object)ssr)), this.retries);
                    this.hits = searchResponse.getHits();
                    if (this.hits.getHits().length == 0) {
                        return null;
                    }
                    this.nextHit = 0;
                }
                catch (Exception e) {
                    throw new JetException("Could not execute SearchScrollRequest to Elastic", (Throwable)e);
                }
            }
            return this.hits.getAt(this.nextHit++);
        }

        public void close() {
            if (this.scrollId != null) {
                this.clearScroll(this.scrollId);
                this.scrollId = null;
            }
        }

        private void clearScroll(String scrollId) {
            ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
            clearScrollRequest.addScrollId(scrollId);
            try {
                ClearScrollResponse response = RetryUtils.withRetry(() -> this.client.clearScroll(clearScrollRequest, (RequestOptions)this.optionsFn.apply((Object)clearScrollRequest)), this.retries);
                if (response.isSucceeded()) {
                    this.logger.fine("Succeeded clearing %s scrolls", (Object)response.getNumFreed());
                } else {
                    this.logger.warning("Clearing scroll " + scrollId + " failed");
                }
            }
            catch (Exception e) {
                this.logger.fine("Could not clear scroll with scrollId=" + scrollId, (Throwable)e);
            }
        }
    }
}

