/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.elastic;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.elastic.impl.RetryUtils;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.SinkBuilder;
import com.hazelcast.logging.ILogger;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

public final class ElasticSinkBuilder<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_NAME = "elasticSink";
    private static final int DEFAULT_LOCAL_PARALLELISM = 2;
    private static final int DEFAULT_RETRIES = 5;
    private SupplierEx<RestClientBuilder> clientFn;
    private SupplierEx<BulkRequest> bulkRequestFn = BulkRequest::new;
    private FunctionEx<? super T, ? extends DocWriteRequest<?>> mapToRequestFn;
    private FunctionEx<? super ActionRequest, RequestOptions> optionsFn = (FunctionEx & Serializable)request -> RequestOptions.DEFAULT;
    private int retries = 5;

    @Nonnull
    public ElasticSinkBuilder<T> clientFn(@Nonnull SupplierEx<RestClientBuilder> clientFn) {
        this.clientFn = (SupplierEx)Util.checkNonNullAndSerializable(clientFn, (String)"clientFn");
        return this;
    }

    @Nonnull
    public ElasticSinkBuilder<T> bulkRequestFn(@Nonnull SupplierEx<BulkRequest> bulkRequestFn) {
        this.bulkRequestFn = (SupplierEx)Util.checkNonNullAndSerializable(bulkRequestFn, (String)"bulkRequestFn");
        return this;
    }

    @Nonnull
    public <T_NEW> ElasticSinkBuilder<T_NEW> mapToRequestFn(@Nonnull FunctionEx<? super T_NEW, ? extends DocWriteRequest<?>> mapToRequestFn) {
        ElasticSinkBuilder newThis = this;
        newThis.mapToRequestFn = (FunctionEx)Util.checkNonNullAndSerializable(mapToRequestFn, (String)"mapToRequestFn");
        return newThis;
    }

    @Nonnull
    public ElasticSinkBuilder<T> optionsFn(@Nonnull FunctionEx<? super ActionRequest, RequestOptions> optionsFn) {
        this.optionsFn = (FunctionEx)Util.checkNonNullAndSerializable(optionsFn, (String)"optionsFn");
        return this;
    }

    @Nonnull
    public ElasticSinkBuilder<T> retries(int retries) {
        if (retries < 0) {
            throw new IllegalArgumentException("retries must be positive");
        }
        this.retries = retries;
        return this;
    }

    @Nonnull
    public Sink<T> build() {
        Objects.requireNonNull(this.clientFn, "clientFn is not set");
        Objects.requireNonNull(this.mapToRequestFn, "mapToRequestFn is not set");
        return SinkBuilder.sinkBuilder((String)DEFAULT_NAME, (FunctionEx & Serializable)ctx -> new BulkContext(new RestHighLevelClient((RestClientBuilder)this.clientFn.get()), this.bulkRequestFn, this.optionsFn, this.retries, ctx.logger())).receiveFn((BiConsumerEx & Serializable)(bulkContext, item) -> bulkContext.add((DocWriteRequest)this.mapToRequestFn.apply(item))).flushFn(BulkContext::flush).destroyFn(BulkContext::close).preferredLocalParallelism(2).build();
    }

    static final class BulkContext {
        private final RestHighLevelClient client;
        private final SupplierEx<BulkRequest> bulkRequestSupplier;
        private final FunctionEx<? super ActionRequest, RequestOptions> optionsFn;
        private final int retries;
        private BulkRequest bulkRequest;
        private final ILogger logger;

        BulkContext(RestHighLevelClient client, SupplierEx<BulkRequest> bulkRequestSupplier, FunctionEx<? super ActionRequest, RequestOptions> optionsFn, int retries, ILogger logger) {
            this.client = client;
            this.bulkRequestSupplier = bulkRequestSupplier;
            this.optionsFn = optionsFn;
            this.bulkRequest = (BulkRequest)bulkRequestSupplier.get();
            this.retries = retries;
            this.logger = logger;
        }

        void add(DocWriteRequest<?> request) {
            this.bulkRequest.add(request);
        }

        void flush() {
            if (!this.bulkRequest.requests().isEmpty()) {
                RetryUtils.withRetry(() -> {
                    BulkResponse response = this.client.bulk(this.bulkRequest, (RequestOptions)this.optionsFn.apply((Object)this.bulkRequest));
                    if (response.hasFailures()) {
                        throw new JetException(response.buildFailureMessage());
                    }
                    if (this.logger.isFineEnabled()) {
                        this.logger.fine("BulkRequest with %s requests succeeded", (Object)this.bulkRequest.requests().size());
                    }
                    return response;
                }, this.retries, IOException.class, JetException.class);
                this.bulkRequest = (BulkRequest)this.bulkRequestSupplier.get();
            }
        }

        void close() throws IOException {
            this.logger.fine("Closing BulkContext");
            try {
                this.flush();
            }
            finally {
                this.client.close();
            }
        }
    }
}

