/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.usercode.impl;

import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.SerializationServiceAware;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.usercode.UserCodeConfig;
import com.hazelcast.usercode.impl.ContainerUserCodeRuntime;
import com.hazelcast.usercode.impl.ContainerUserCodeRuntimeControllerProxy;
import com.hazelcast.usercode.impl.MessageBase;
import com.hazelcast.usercode.impl.RuntimeInitArgs;
import com.hazelcast.usercode.impl.UserCodeException;
import com.hazelcast.usercode.impl.UserCodeRuntime;
import com.hazelcast.usercode.impl.UserCodeService;
import com.hazelcast.usercode.impl.transports.grpc.GrpcTransport;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

class ContainerUserCodeService
implements ManagedService,
UserCodeService,
SerializationServiceAware {
    public static final String SERVICE_NAME = "hz:impl:containerUserCodeService";
    protected SerializationService serializationService;
    private final ILogger logger;
    private final ContainerUserCodeRuntimeControllerProxy controller;
    private final LoggingService logging;
    private final HazelcastProperties hzProperties;
    private final AtomicBoolean isDestroyed = new AtomicBoolean();

    ContainerUserCodeService(ContainerUserCodeRuntimeControllerProxy controller, HazelcastProperties props, SerializationService serializationService, LoggingService logging) {
        this.logging = logging;
        this.logger = this.logging.getLogger(ContainerUserCodeService.class);
        this.controller = controller;
        this.serializationService = serializationService;
        this.hzProperties = props;
    }

    protected CompletableFuture<UserCodeRuntime> initialize(UserCodeRuntime runtime, RuntimeInitArgs initMessage) throws InterruptedException {
        try {
            runtime.getTransport().initTransport().get();
        }
        catch (UserCodeException | ExecutionException e) {
            return CompletableFuture.failedFuture((Throwable)e);
        }
        return runtime.getTransport().initRuntime(initMessage).handle((unused, throwable) -> {
            if (throwable != null) {
                throw new UserCodeException("Exception thrown while initializing the user code runtime. " + throwable.getMessage());
            }
            return runtime;
        });
    }

    protected CompletableFuture<Void> terminate(UserCodeRuntime runtime) {
        try {
            MessageBase response = runtime.getTransport().destroy().get();
            if (response.isError()) {
                this.logger.warning("Exception while stopping the runtime " + runtime.getName() + " container using the END message: " + response.getErrorMessage());
            }
        }
        catch (NullPointerException | ExecutionException ex) {
            this.logger.warning("Exception thrown while terminating the runtime [" + runtime.getName() + "]. Runtime could NOT be destroyed or was nevercreated.", (Throwable)ex);
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
        return CompletableFuture.completedFuture(null);
    }

    public void setSerializationService(SerializationService serializationService) {
        this.serializationService = serializationService;
    }

    public CompletableFuture<UserCodeRuntime> startRuntime(UserCodeConfig config, RuntimeInitArgs initMessage) throws InterruptedException {
        String containerAddress = this.controller.createContainer(config.getImageName());
        GrpcTransport transport = new GrpcTransport(containerAddress, config.getName(), this.hzProperties, config, this.logging.getLogger(GrpcTransport.class));
        ContainerUserCodeRuntime runtime = new ContainerUserCodeRuntime(this, transport, this.serializationService, containerAddress);
        return this.initialize(runtime, initMessage).whenComplete((rt, throwable) -> {
            String name = "[" + config.getName() + "] at " + containerAddress;
            if (throwable != null) {
                this.logger.severe("Cannot start the runtime " + name + ", destroying the container...");
                this.destroyRuntime(runtime);
            } else {
                this.logger.info("New runtime " + name + " is created.");
            }
        });
    }

    public CompletableFuture<Void> destroyRuntime(UserCodeRuntime runtime) {
        if (!(runtime instanceof ContainerUserCodeRuntime)) {
            throw new UnsupportedOperationException("runtime is not UserCodeContainerRuntime instance.");
        }
        String name = runtime.getName();
        this.logger.fine("Destroying user code runtime [%s].", (Object)name);
        return ((CompletableFuture)this.terminate(runtime).thenRun(() -> this.controller.deleteContainer(name))).thenApply(voidResponse -> {
            this.logger.info("Runtime [" + name + "] is destroyed.");
            return voidResponse;
        });
    }

    public void init(NodeEngine nodeEngine, Properties properties) {
    }

    public void reset() {
    }

    public void shutdown(boolean terminate) {
        if (this.isDestroyed.compareAndExchange(false, true)) {
            this.controller.shutdown();
        }
    }

    public boolean isDestroyed() {
        return this.isDestroyed.get();
    }
}

