/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.storage.graph;

import com.hazelcast.shaded.io.github.jbellis.jvector.vector.ArrayVectorFloat;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.types.VectorFloat;

class HazelcastVectorUtil {
    private HazelcastVectorUtil() {
    }

    public static float cosine(VectorFloat<?> a2, VectorFloat<?> b) {
        if (a2.length() != b.length()) {
            throw new IllegalArgumentException("vector dimensions differ: " + a2.length() + "!=" + b.length());
        }
        float r = HazelcastVectorUtil.cosine0(a2, b);
        assert (Float.isFinite(r)) : String.format("cosine(%s, %s) = %s", a2, b, Float.valueOf(r));
        return r;
    }

    private static float cosine0(VectorFloat<?> av, VectorFloat<?> bv) {
        int i;
        float[] a2 = ((ArrayVectorFloat)av).get();
        float[] b = ((ArrayVectorFloat)bv).get();
        float norm1 = 0.0f;
        float norm2 = 0.0f;
        float sum = 0.0f;
        for (i = 0; i < a2.length % 8; ++i) {
            sum += b[i] * a2[i];
            norm1 += a2[i] * a2[i];
            norm2 += b[i] * b[i];
        }
        if (a2.length < 8) {
            return (float)((double)sum / Math.sqrt(norm1 * norm2));
        }
        while (i + 7 < a2.length) {
            sum += b[i + 0] * a2[i + 0] + b[i + 1] * a2[i + 1] + b[i + 2] * a2[i + 2] + b[i + 3] * a2[i + 3] + b[i + 4] * a2[i + 4] + b[i + 5] * a2[i + 5] + b[i + 6] * a2[i + 6] + b[i + 7] * a2[i + 7];
            norm1 += a2[i + 0] * a2[i + 0] + a2[i + 1] * a2[i + 1] + a2[i + 2] * a2[i + 2] + a2[i + 3] * a2[i + 3] + a2[i + 4] * a2[i + 4] + a2[i + 5] * a2[i + 5] + a2[i + 6] * a2[i + 6] + a2[i + 7] * a2[i + 7];
            norm2 += b[i + 0] * b[i + 0] + b[i + 1] * b[i + 1] + b[i + 2] * b[i + 2] + b[i + 3] * b[i + 3] + b[i + 4] * b[i + 4] + b[i + 5] * b[i + 5] + b[i + 6] * b[i + 6] + b[i + 7] * b[i + 7];
            i += 8;
        }
        return (float)((double)sum / Math.sqrt(norm1 * norm2));
    }
}

