/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.storage.graph;

import com.hazelcast.shaded.io.github.jbellis.jvector.vector.DefaultVectorizationProvider;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.VectorUtil;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.VectorizationProvider;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.types.VectorFloat;
import com.hazelcast.vector.impl.storage.graph.HazelcastVectorSimilarityFunction;
import com.hazelcast.vector.impl.storage.graph.HazelcastVectorUtil;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum HazelcastBuiltinVectorSimilarityFunction implements HazelcastVectorSimilarityFunction
{
    EUCLIDEAN{

        @Override
        public float compare(VectorFloat<?> v1, VectorFloat<?> v2) {
            return 1.0f / (1.0f + VectorUtil.squareL2Distance(v1, v2));
        }
    }
    ,
    DOT_PRODUCT{

        @Override
        public float compare(VectorFloat<?> v1, VectorFloat<?> v2) {
            return (1.0f + VectorUtil.dotProduct(v1, v2)) / 2.0f;
        }
    }
    ,
    COSINE{

        @Override
        public float compare(VectorFloat<?> v1, VectorFloat<?> v2) {
            return (1.0f + VectorUtil.cosine(v1, v2)) / 2.0f;
        }
    }
    ,
    COSINE_UNROLLED_NOT_VECTORIZED{

        @Override
        public float compare(VectorFloat<?> v1, VectorFloat<?> v2) {
            return (1.0f + HazelcastVectorUtil.cosine(v1, v2)) / 2.0f;
        }
    };


    private static boolean isVectorApiAvailable() {
        return !(VectorizationProvider.getInstance() instanceof DefaultVectorizationProvider);
    }

    public static HazelcastBuiltinVectorSimilarityFunction cosine() {
        if (HazelcastBuiltinVectorSimilarityFunction.isVectorApiAvailable()) {
            return COSINE;
        }
        return COSINE_UNROLLED_NOT_VECTORIZED;
    }
}

