/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.storage;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordReaderWriter;
import java.util.Objects;

public class SimpleVectorRecord<V>
implements Record<V> {
    private volatile V value;
    private volatile int version;

    public SimpleVectorRecord(V value, int version) {
        this.value = value;
        this.version = version;
    }

    @Override
    public final int getVersion() {
        return this.version;
    }

    @Override
    public final void setVersion(int version) {
        this.version = version;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public void setValue(V value) {
        this.value = value;
    }

    @Override
    public long getCost() {
        return JVMUtil.OBJECT_HEADER_SIZE + JVMUtil.REFERENCE_COST_IN_BYTES + ((Data)this.value).getHeapCost() + 4;
    }

    @Override
    public RecordReaderWriter getMatchingRecordReaderWriter() {
        throw new UnsupportedOperationException("SimpleVectorRecord cannot be serialized");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleVectorRecord that = (SimpleVectorRecord)o;
        if (this.version != that.version) {
            return false;
        }
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + this.version;
        return result;
    }

    public String toString() {
        return "SimpleVectorRecord{value=" + String.valueOf(this.value) + ", version=" + this.version + "}";
    }
}

