/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.stats;

import com.hazelcast.vector.impl.stats.OnDemandStats;
import java.util.Objects;

public final class OnDemandStatsImpl
implements OnDemandStats {
    private long size;
    private long heapBytesUsed;

    public OnDemandStatsImpl(long size, long heapBytesUsed) {
        this.size = size;
        this.heapBytesUsed = heapBytesUsed;
    }

    public OnDemandStatsImpl() {
        this(0L, 0L);
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long heapBytesUsed() {
        return this.heapBytesUsed;
    }

    public OnDemandStatsImpl add(OnDemandStats other) {
        this.size += other.size();
        this.heapBytesUsed += other.heapBytesUsed();
        return this;
    }

    public OnDemandStatsImpl addHeapBytes(long heapBytesUsed) {
        this.heapBytesUsed += heapBytesUsed;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        OnDemandStatsImpl that = (OnDemandStatsImpl)obj;
        return this.size == that.size && this.heapBytesUsed == that.heapBytesUsed;
    }

    public int hashCode() {
        return Objects.hash(this.size, this.heapBytesUsed);
    }

    public String toString() {
        return "OnDemandStats[size=" + this.size + ", heapBytesUsed=" + this.heapBytesUsed + "]";
    }
}

