/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.stats;

import com.hazelcast.vector.impl.stats.CollectionOnDemandStats;
import com.hazelcast.vector.impl.stats.OnDemandStats;
import com.hazelcast.vector.impl.stats.OnDemandStatsImpl;
import com.hazelcast.vector.impl.stats.VectorIndexStats;
import com.hazelcast.vector.impl.stats.VectorIndexStatsImpl;
import java.util.Objects;

public final class CollectionOnDemandStatsImpl
implements CollectionOnDemandStats {
    private static final OnDemandStatsImpl ZERO_STATS = new OnDemandStatsImpl();
    private static final VectorIndexStats ZERO_INDEX_STATS = new VectorIndexStatsImpl();
    private final OnDemandStatsImpl owned;
    private final OnDemandStatsImpl backup;
    private final long heapBytesUsed;
    private final VectorIndexStats vectorIndexStats;

    public CollectionOnDemandStatsImpl(OnDemandStatsImpl owned, OnDemandStatsImpl backup, long heapBytesUsed, VectorIndexStats vectorIndexStats) {
        this.owned = owned;
        this.backup = backup;
        this.heapBytesUsed = heapBytesUsed;
        this.vectorIndexStats = vectorIndexStats;
    }

    public CollectionOnDemandStatsImpl(long heapBytesUsed) {
        this(ZERO_STATS, ZERO_STATS, heapBytesUsed, ZERO_INDEX_STATS);
    }

    @Override
    public OnDemandStats owned() {
        return this.owned;
    }

    @Override
    public OnDemandStats backup() {
        return this.backup;
    }

    @Override
    public long heapBytesUsed() {
        return this.heapBytesUsed;
    }

    @Override
    public VectorIndexStats getVectorIndexStats() {
        return this.vectorIndexStats;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CollectionOnDemandStatsImpl that = (CollectionOnDemandStatsImpl)obj;
        return Objects.equals(this.owned, that.owned) && Objects.equals(this.backup, that.backup) && this.heapBytesUsed == that.heapBytesUsed && Objects.equals(this.vectorIndexStats, that.vectorIndexStats);
    }

    public int hashCode() {
        return Objects.hash(this.owned, this.backup, this.heapBytesUsed, this.vectorIndexStats);
    }

    public String toString() {
        return "CollectionOnDemandStats[owned=" + String.valueOf(this.owned) + ", backup=" + String.valueOf(this.backup) + ", heapBytesUsed=" + this.heapBytesUsed + ", vectorIndexStats=" + String.valueOf(this.vectorIndexStats) + "]";
    }
}

