/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.service;

import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.vector.VectorCollectionConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.config.MergePolicyValidator;
import com.hazelcast.internal.partition.ChunkSupplier;
import com.hazelcast.internal.partition.ChunkedMigrationAwareService;
import com.hazelcast.internal.partition.MigrationEndpoint;
import com.hazelcast.internal.partition.OffloadedReplicationPreparation;
import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.services.DistributedObjectNamespace;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.services.SplitBrainHandlerService;
import com.hazelcast.internal.services.SplitBrainProtectionAwareService;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.executor.ExecutorType;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.vector.SearchOptions;
import com.hazelcast.vector.impl.Hints;
import com.hazelcast.vector.impl.VectorCollectionOptimizationManager;
import com.hazelcast.vector.impl.VectorCollectionService;
import com.hazelcast.vector.impl.ops.ReplicationOperation;
import com.hazelcast.vector.impl.proxy.VectorCollectionProxy;
import com.hazelcast.vector.impl.query.PartitionLimitEstimatingSearcher;
import com.hazelcast.vector.impl.query.Searcher;
import com.hazelcast.vector.impl.query.SingleStageSearcher;
import com.hazelcast.vector.impl.query.TwoStageSearcher;
import com.hazelcast.vector.impl.service.VectorCollectionOptimizationManagerImpl;
import com.hazelcast.vector.impl.service.VectorCollectionSplitBrainHandlerService;
import com.hazelcast.vector.impl.stats.CollectionOnDemandStats;
import com.hazelcast.vector.impl.stats.CollectionOnDemandStatsImpl;
import com.hazelcast.vector.impl.stats.LocalVectorCollectionStatsImpl;
import com.hazelcast.vector.impl.stats.LocalVectorCollectionStatsProvider;
import com.hazelcast.vector.impl.stats.OnDemandStatsImpl;
import com.hazelcast.vector.impl.stats.VectorIndexStatsImpl;
import com.hazelcast.vector.impl.storage.OnHeapVectorCollectionObjectProvider;
import com.hazelcast.vector.impl.storage.VectorCollectionStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VectorCollectionServiceImpl
implements VectorCollectionService,
ChunkedMigrationAwareService,
OffloadedReplicationPreparation,
SplitBrainProtectionAwareService,
SplitBrainHandlerService {
    public static final String VECTOR_QUERY_EXECUTOR = "hz:vector-query";
    public static final HazelcastProperty MAX_SUCCESSIVE_OFFLOADED_OP_RUN_MILLIS = new HazelcastProperty("hazelcast.vector.max.successive.run.millis", 0, TimeUnit.MILLISECONDS);
    public static final HazelcastProperty MAX_CONCURRENT_OPTIMIZE = new HazelcastProperty("hazelcast.vector.max.concurrent.optimize", 1);
    public static final long FIXED_HEAP_BYTES_USED = (long)JVMUtil.OBJECT_HEADER_SIZE + 11L * (long)JVMUtil.REFERENCE_COST_IN_BYTES + 8L + (long)JVMUtil.OBJECT_HEADER_SIZE + (long)JVMUtil.REFERENCE_COST_IN_BYTES;
    static final long HEAP_BYTES_USED_PER_COLLECTION_NAME = 2L * (long)JVMUtil.REFERENCE_COST_IN_BYTES;
    static final long HEAP_BYTES_USED_PER_PARTITION_STORAGE = 2L * (long)JVMUtil.REFERENCE_COST_IN_BYTES + 4L;
    static final long HEAP_BYTES_USED_PER_DISTRIBUTED_OBJECT_NAME = (long)(JVMUtil.REFERENCE_COST_IN_BYTES + JVMUtil.OBJECT_HEADER_SIZE) + 2L * (long)JVMUtil.REFERENCE_COST_IN_BYTES;
    static final long HEAP_BYTES_USED_PER_SPLITBRAINPROTECTION_CACHE_ENTRY = 2L * (long)JVMUtil.REFERENCE_COST_IN_BYTES;
    private static final Function<String, ObjectNamespace> OBJECT_NAMESPACE_CONSTRUCTOR = VectorCollectionServiceImpl::createObjectNamespace;
    private static final Object NULL_OBJECT = new Object();
    private final Function<String, Object> splitBrainProtectionNameConstructor = name -> {
        String splitBrainProtectionName = this.getExistingVectorCollectionConfig((String)name).getSplitBrainProtectionName();
        return splitBrainProtectionName == null ? NULL_OBJECT : splitBrainProtectionName;
    };
    private final NodeEngine nodeEngine;
    private final ILogger logger;
    private final ConcurrentHashMap<String, ConcurrentHashMap<Integer, VectorCollectionStorage>> storage;
    private final ConcurrentHashMap<String, ObjectNamespace> namespaces;
    private final ConcurrentHashMap<String, Object> splitBrainProtectionNames;
    private final long maxOffloadedRunNanos;
    private final Searcher singleStageSearcher;
    private final Searcher twoStageSearcher;
    private final LocalVectorCollectionStatsProvider statisticsProvider;
    private final VectorCollectionSplitBrainHandlerService splitBrainHandlerService;
    private final VectorCollectionOptimizationManager optimizationManager;

    public VectorCollectionServiceImpl(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(VectorCollectionServiceImpl.class);
        this.storage = new ConcurrentHashMap();
        this.namespaces = new ConcurrentHashMap();
        this.splitBrainProtectionNames = new ConcurrentHashMap();
        this.maxOffloadedRunNanos = nodeEngine.getProperties().getNanos(MAX_SUCCESSIVE_OFFLOADED_OP_RUN_MILLIS);
        this.optimizationManager = new VectorCollectionOptimizationManagerImpl(nodeEngine);
        this.singleStageSearcher = new PartitionLimitEstimatingSearcher(nodeEngine, new SingleStageSearcher(nodeEngine));
        this.twoStageSearcher = new PartitionLimitEstimatingSearcher(nodeEngine, new TwoStageSearcher(nodeEngine));
        this.statisticsProvider = new LocalVectorCollectionStatsProvider(nodeEngine, this);
        this.splitBrainHandlerService = new VectorCollectionSplitBrainHandlerService(nodeEngine);
        this.registerVectorQueryExecutor(nodeEngine);
    }

    private void registerVectorQueryExecutor(NodeEngine nodeEngine) {
        int physicalCoreCount = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        this.logger.finest("Registering new vector query executor with default threadCount=%d", physicalCoreCount);
        nodeEngine.getExecutionService().register(VECTOR_QUERY_EXECUTOR, physicalCoreCount, Integer.MAX_VALUE, ExecutorType.CACHED);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        boolean dsMetricsEnabled = nodeEngine.getProperties().getBoolean(ClusterProperty.METRICS_DATASTRUCTURES);
        if (dsMetricsEnabled) {
            nodeEngine.getMetricsRegistry().registerDynamicMetricsProvider(this.statisticsProvider);
        }
    }

    @Override
    public void reset() {
        this.storage.clear();
        this.namespaces.clear();
        this.statisticsProvider.reset();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.storage.clear();
        this.namespaces.clear();
    }

    @Override
    public DistributedObject createDistributedObject(String objectName, UUID source, boolean local) {
        VectorCollectionConfig config = this.getAndValidateExistingVectorCollectionConfig(objectName);
        this.getStatistics(objectName);
        return new VectorCollectionProxy(this.nodeEngine, this, objectName, config);
    }

    @Override
    public void destroyDistributedObject(String objectName, boolean local) {
        this.storage.remove(objectName);
        this.namespaces.remove(objectName);
        this.statisticsProvider.destroyStatistics(objectName);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public VectorCollectionStorage getStorage(String vectorCollectionName, int partitionId) {
        return this.storage.computeIfAbsent(vectorCollectionName, name -> new ConcurrentHashMap()).computeIfAbsent(partitionId, i -> this.createStorage(vectorCollectionName, partitionId));
    }

    @Override
    public VectorCollectionStorage createStorage(String vectorCollectionName, int partitionId) {
        VectorCollectionConfig config = this.getAndValidateExistingVectorCollectionConfig(vectorCollectionName);
        return new VectorCollectionStorage(this.nodeEngine, vectorCollectionName, partitionId, config, OnHeapVectorCollectionObjectProvider.getInstance());
    }

    @Override
    public void attachStorage(@Nonnull VectorCollectionStorage collectionStorage) {
        VectorCollectionStorage previousStorage = this.storage.computeIfAbsent(collectionStorage.getName(), name -> new ConcurrentHashMap()).put(collectionStorage.getPartitionId(), collectionStorage);
        if (previousStorage != null) {
            this.logger.warning(String.format("Existing storage for collection %s partition %d was replaced", collectionStorage.getName(), collectionStorage.getPartitionId()));
        }
    }

    @Override
    public void destroyStorage(String vectorCollectionName, int partitionId) {
        ConcurrentHashMap<Integer, VectorCollectionStorage> maybeCollection = this.storage.get(vectorCollectionName);
        if (maybeCollection == null) {
            return;
        }
        VectorCollectionStorage previous = maybeCollection.remove(partitionId);
        if (previous != null) {
            this.logger.fine("Destroyed storage for collection %s partition %d", vectorCollectionName, partitionId);
        }
    }

    @Override
    public VectorCollectionStorage getStorageOrNull(String vectorCollectionName, int partitionId) {
        return (VectorCollectionStorage)this.storage.computeIfAbsent(vectorCollectionName, name -> new ConcurrentHashMap()).get(partitionId);
    }

    @Nonnull
    private VectorCollectionConfig getAndValidateExistingVectorCollectionConfig(String objectName) {
        VectorCollectionConfig config = this.getExistingVectorCollectionConfig(objectName);
        this.validateConfig(config);
        return config;
    }

    @Nonnull
    public VectorCollectionConfig getExistingVectorCollectionConfig(String objectName) {
        VectorCollectionConfig config = this.nodeEngine.getConfig().getVectorCollectionConfigOrNull(objectName);
        if (config == null) {
            throw new IllegalArgumentException("Configuration for vector collection " + objectName + " does not exist");
        }
        return config;
    }

    private void validateConfig(VectorCollectionConfig config) {
        if (config.getVectorIndexConfigs().isEmpty()) {
            throw new InvalidConfigurationException("Vector collection must have at least one index.");
        }
        if (!this.nodeEngine.getClusterService().getClusterVersion().isGreaterOrEqual(Versions.V5_6) && config.getTotalBackupCount() > 0) {
            throw new UnsupportedOperationException(String.format("Vector collection backups require cluster version %s or greater", Versions.V5_6));
        }
        MergePolicyValidator.checkVectorCollectionMergePolicy(config, config.getMergePolicyConfig().getPolicy(), this.nodeEngine.getSplitBrainMergePolicyProvider());
    }

    @Override
    @Nonnull
    public Searcher getSearcher(String collectionName, SearchOptions options) {
        int clusterSize = this.nodeEngine.getClusterService().getSize(MemberSelectors.DATA_MEMBER_SELECTOR);
        if (clusterSize <= 1) {
            return this.singleStageSearcher;
        }
        if (Boolean.TRUE == Hints.FORCE_SINGLE_STAGE_SEARCH.get(options)) {
            return this.singleStageSearcher;
        }
        return this.twoStageSearcher;
    }

    @Override
    public LocalVectorCollectionStatsImpl getStatistics(String vectorCollectionName) {
        return this.statisticsProvider.getStatistics(vectorCollectionName);
    }

    public long getMaxOffloadedRunNanos() {
        return this.maxOffloadedRunNanos;
    }

    @Override
    public CollectionOnDemandStats getOnDemandStats(String vectorCollectionName) {
        ConcurrentMap chm = this.storage.get(vectorCollectionName);
        return chm == null ? this.getCollectionOnDemandStatsWithoutStorage(vectorCollectionName) : this.getCollectionOnDemandStatsWithStorage(chm);
    }

    @Nonnull
    private CollectionOnDemandStatsImpl getCollectionOnDemandStatsWithoutStorage(String vectorCollectionName) {
        return new CollectionOnDemandStatsImpl(this.statisticsProvider.hasStatistics(vectorCollectionName) ? LocalVectorCollectionStatsProvider.ENTRY_HEAP_BYTES_USED : 0L);
    }

    @Nonnull
    private CollectionOnDemandStatsImpl getCollectionOnDemandStatsWithStorage(ConcurrentMap<Integer, VectorCollectionStorage> chm) {
        OnDemandStatsImpl owned = new OnDemandStatsImpl();
        OnDemandStatsImpl backup = new OnDemandStatsImpl();
        VectorIndexStatsImpl aggregatedIndexStats = new VectorIndexStatsImpl();
        chm.forEach((partitionId, storage) -> {
            boolean local = this.nodeEngine.getPartitionService().getPartition((int)partitionId, false).isLocal();
            (local ? owned : backup).add(storage.getOnDemandStats()).addHeapBytes(HEAP_BYTES_USED_PER_PARTITION_STORAGE);
            aggregatedIndexStats.add(storage.getVectorIndexStats());
        });
        long heapBytesUsed = owned.heapBytesUsed() + backup.heapBytesUsed() + HEAP_BYTES_USED_PER_COLLECTION_NAME + HEAP_BYTES_USED_PER_DISTRIBUTED_OBJECT_NAME + LocalVectorCollectionStatsProvider.ENTRY_HEAP_BYTES_USED;
        return new CollectionOnDemandStatsImpl(owned, backup, heapBytesUsed, aggregatedIndexStats);
    }

    @Override
    public long heapBytesUsed() {
        return FIXED_HEAP_BYTES_USED + (long)this.storage.size() * HEAP_BYTES_USED_PER_COLLECTION_NAME + this.storage.values().stream().mapToLong(chm -> chm.values().stream().mapToLong(vcStorage -> HEAP_BYTES_USED_PER_PARTITION_STORAGE + vcStorage.heapBytesUsed()).sum()).sum() + this.singleStageSearcher.heapBytesUsed() + this.twoStageSearcher.heapBytesUsed() + (long)this.namespaces.size() * HEAP_BYTES_USED_PER_DISTRIBUTED_OBJECT_NAME + (long)this.splitBrainProtectionNames.size() * HEAP_BYTES_USED_PER_SPLITBRAINPROTECTION_CACHE_ENTRY + this.optimizationManager.heapBytesUsed() + this.statisticsProvider.heapBytesUsed();
    }

    @Override
    public Collection<ServiceNamespace> getAllServiceNamespaces(PartitionReplicationEvent event) {
        Collection namespaces = this.storage.entrySet().stream().filter(collectionEntry -> this.isEligibleForReplication(event.getReplicaIndex(), (VectorCollectionStorage)((ConcurrentHashMap)collectionEntry.getValue()).get(event.getPartitionId()))).map(collectionEntry -> this.getObjectNamespace((String)collectionEntry.getKey())).collect(Collectors.toCollection(HashSet::new));
        return namespaces;
    }

    @Override
    public boolean isKnownServiceNamespace(ServiceNamespace namespace) {
        if (namespace instanceof ObjectNamespace) {
            ObjectNamespace ons = (ObjectNamespace)namespace;
            return ons.getServiceName().equals("hz:service:vector") && this.storage.containsKey(ons.getObjectName());
        }
        return false;
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        HashMap<String, VectorCollectionStorage> migrationData = new HashMap<String, VectorCollectionStorage>();
        for (ServiceNamespace ns : namespaces) {
            if (!(ns instanceof ObjectNamespace)) continue;
            ObjectNamespace ons = (ObjectNamespace)ns;
            String collectionName = ons.getObjectName();
            VectorCollectionStorage maybeStorage = this.getStorageOrNull(collectionName, event.getPartitionId());
            if (!this.isEligibleForReplication(event.getReplicaIndex(), maybeStorage)) continue;
            migrationData.put(collectionName, maybeStorage);
        }
        return migrationData.isEmpty() ? null : new ReplicationOperation(this.nodeEngine, migrationData, event.getPartitionId(), event.getReplicaIndex());
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        return this.prepareReplicationOperation(event, this.getAllServiceNamespaces(event));
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearPartitionReplica(event.getPartitionId(), event.getNewReplicaIndex());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearPartitionReplica(event.getPartitionId(), event.getCurrentReplicaIndex());
        }
    }

    private void clearPartitionReplica(int partitionId, int durabilityThreshold) {
        for (Map.Entry<String, ConcurrentHashMap<Integer, VectorCollectionStorage>> entry : this.storage.entrySet()) {
            ConcurrentHashMap<Integer, VectorCollectionStorage> collectionPartitions = entry.getValue();
            VectorCollectionStorage partition = collectionPartitions.get(partitionId);
            if (partition == null || durabilityThreshold <= partition.getConfig().getTotalBackupCount()) continue;
            collectionPartitions.remove(partitionId);
        }
    }

    @Override
    public ChunkSupplier newChunkSupplier(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        assert (!ThreadUtil.isRunningOnPartitionThread());
        for (ServiceNamespace ns : namespaces) {
            if (!(ns instanceof ObjectNamespace)) continue;
            ObjectNamespace ons = (ObjectNamespace)ns;
            String collectionName = ons.getObjectName();
            VectorCollectionStorage maybeStorage = this.getStorageOrNull(collectionName, event.getPartitionId());
            if (!this.isEligibleForReplication(event.getReplicaIndex(), maybeStorage)) continue;
            maybeStorage.prepareForMigration();
        }
        return ChunkedMigrationAwareService.super.newChunkSupplier(event, namespaces);
    }

    private boolean isReplicaIndexEligibleForReplication(int replicaIndex, int configuredBackupCount) {
        return replicaIndex <= configuredBackupCount;
    }

    private boolean isEligibleForReplication(int replicaIndex, @Nullable VectorCollectionStorage maybeStorage) {
        return maybeStorage != null && this.isReplicaIndexEligibleForReplication(replicaIndex, maybeStorage.getConfig().getTotalBackupCount());
    }

    @Override
    public boolean shouldOffload() {
        return true;
    }

    @Override
    public String getSplitBrainProtectionName(String name) {
        Object splitBrainProtectionName = this.splitBrainProtectionNames.computeIfAbsent(name, this.splitBrainProtectionNameConstructor);
        return splitBrainProtectionName == NULL_OBJECT ? null : (String)splitBrainProtectionName;
    }

    @Override
    public Runnable prepareMergeRunnable() {
        return this.splitBrainHandlerService.prepareMergeRunnable();
    }

    @Override
    @Nonnull
    public Set<String> getAllExistingVectorCollectionNames() {
        HashSet<String> allNames = new HashSet<String>(this.storage.keySet());
        allNames.addAll(this.nodeEngine.getProxyService().getDistributedObjectNames("hz:service:vector"));
        return allNames;
    }

    @Override
    public ObjectNamespace getObjectNamespace(String collectionName) {
        return this.namespaces.computeIfAbsent(collectionName, OBJECT_NAMESPACE_CONSTRUCTOR);
    }

    @Override
    public VectorCollectionOptimizationManager getOptimizationManager() {
        return this.optimizationManager;
    }

    Iterator<VectorCollectionStorage> storageIterator(int partitionId) {
        ArrayList<VectorCollectionStorage> storages = new ArrayList<VectorCollectionStorage>();
        for (Map.Entry<String, ConcurrentHashMap<Integer, VectorCollectionStorage>> entry : this.storage.entrySet()) {
            if (!entry.getValue().containsKey(partitionId)) continue;
            storages.add(entry.getValue().get(partitionId));
        }
        return storages.iterator();
    }

    private static ObjectNamespace createObjectNamespace(String collectionName) {
        return new DistributedObjectNamespace("hz:service:vector", collectionName);
    }
}

