/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.query;

import com.hazelcast.client.impl.ClientEndpoint;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.internal.util.collection.ReadOptimizedLruCache;
import com.hazelcast.logging.ILogger;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.BinomialDistribution;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.vector.SearchOptions;
import com.hazelcast.vector.SearchOptionsBuilder;
import com.hazelcast.vector.SearchResults;
import com.hazelcast.vector.VectorValues;
import com.hazelcast.vector.impl.Hints;
import com.hazelcast.vector.impl.query.Searcher;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PartitionLimitEstimatingSearcher
implements Searcher {
    public static final long FIXED_HEAP_BYTES_USED = (long)JVMUtil.OBJECT_HEADER_SIZE + 3L * (long)JVMUtil.REFERENCE_COST_IN_BYTES + 4L + 16L;
    private static final double PROBABILITY_OF_OMISSION = 1.0E-4;
    private static final int CACHE_SIZE = 50;
    private static final int CACHE_THRESHOLD = 50 + Math.min(5, 50);
    private final int partitionCount;
    private final ILogger logger;
    private final double pSuccess;
    private final double acceptableOmissionProbability1Partition;
    private final ReadOptimizedLruCache<Integer, Integer> partitionLimitCache = new ReadOptimizedLruCache(50, CACHE_THRESHOLD);
    private final Searcher delegate;

    public PartitionLimitEstimatingSearcher(@Nonnull NodeEngine nodeEngine, @Nonnull Searcher delegate) {
        this(nodeEngine.getLogger(PartitionLimitEstimatingSearcher.class), nodeEngine.getPartitionService().getPartitionCount(), delegate);
    }

    PartitionLimitEstimatingSearcher(@Nonnull ILogger logger, int partitionCount, @Nonnull Searcher delegate) {
        this.delegate = delegate;
        this.logger = logger;
        this.partitionCount = partitionCount;
        this.pSuccess = 1.0 / (double)partitionCount;
        this.acceptableOmissionProbability1Partition = 1.0E-4 / (double)partitionCount;
    }

    @Override
    public CompletableFuture<SearchResults<Data, Data>> search(String collectionName, VectorValues vectors, SearchOptions options, @Nullable ClientEndpoint endpoint) {
        SearchOptions effectiveOptions;
        if (this.partitionCount > 1 && options.getLimit() > 1 && !Hints.PARTITION_LIMIT.isPresent(options)) {
            int partitionLimit = this.partitionLimitCache.computeIfAbsent(options.getLimit(), topK -> {
                BinomialDistribution bd = BinomialDistribution.of(topK, this.pSuccess);
                int estimatedPartitionLimit = bd.inverseSurvivalProbability(this.acceptableOmissionProbability1Partition);
                this.logger.info(String.format("Calculated partitionLimit = %d for topK = %d", estimatedPartitionLimit, topK));
                return estimatedPartitionLimit;
            });
            this.logger.finest("Using partitionLimit = %d for %s", partitionLimit, options);
            SearchOptionsBuilder effectiveOptionsBuilder = options.toBuilder().hint(Hints.PARTITION_LIMIT, Integer.valueOf(partitionLimit));
            Integer maybeEfSearch = Hints.EF_SEARCH.get(options);
            if (maybeEfSearch != null && maybeEfSearch < partitionLimit) {
                if (maybeEfSearch * this.partitionCount < options.getLimit()) {
                    return CompletableFuture.failedFuture(new IllegalArgumentException("efSearch is not sufficient to generate full requested result"));
                }
                this.logger.info(String.format("Configured efSearch (%d) it lower than default partitionLimit (%d). This can worsen quality of the results. To disable this warning set partitionLimit explicitly.", maybeEfSearch, partitionLimit));
                effectiveOptionsBuilder.hint(Hints.PARTITION_LIMIT, maybeEfSearch);
            } else if (maybeEfSearch == null) {
                effectiveOptionsBuilder.hint(Hints.EF_SEARCH, Integer.valueOf(options.getLimit()));
            }
            effectiveOptions = effectiveOptionsBuilder.build();
        } else {
            effectiveOptions = options;
        }
        return this.delegate.search(collectionName, vectors, effectiveOptions, endpoint);
    }

    @Override
    public Searcher getBaseSearcher() {
        return this.delegate.getBaseSearcher();
    }

    @Override
    public long heapBytesUsed() {
        return FIXED_HEAP_BYTES_USED + (long)this.partitionLimitCache.size() * 2L * (long)JVMUtil.REFERENCE_COST_IN_BYTES + this.delegate.heapBytesUsed();
    }
}

