/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.protocol.task;

import com.hazelcast.client.impl.protocol.MessageTaskFactory;
import com.hazelcast.client.impl.protocol.MessageTaskFactoryProvider;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.collection.Int2ObjectHashMap;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.vector.impl.protocol.task.VectorCollectionClearMessageTask;
import com.hazelcast.vector.impl.protocol.task.VectorCollectionDeleteMessageTask;
import com.hazelcast.vector.impl.protocol.task.VectorCollectionGetMessageTask;
import com.hazelcast.vector.impl.protocol.task.VectorCollectionOptimizeMessageTask;
import com.hazelcast.vector.impl.protocol.task.VectorCollectionPutAllMessageTask;
import com.hazelcast.vector.impl.protocol.task.VectorCollectionPutIfAbsentMessageTask;
import com.hazelcast.vector.impl.protocol.task.VectorCollectionPutMessageTask;
import com.hazelcast.vector.impl.protocol.task.VectorCollectionRemoveMessageTask;
import com.hazelcast.vector.impl.protocol.task.VectorCollectionSearchNearVectorMessageTask;
import com.hazelcast.vector.impl.protocol.task.VectorCollectionSetMessageTask;
import com.hazelcast.vector.impl.protocol.task.VectorCollectionSizeMessageTask;
import com.hazelcast.vector.impl.protocol.task.dynamicconfig.AddVectorCollectionConfigMessageTask;

public class VectorMessageTaskFactoryProvider
implements MessageTaskFactoryProvider {
    private static final int INITIAL_CAPACITY = 10;
    private final Int2ObjectHashMap<MessageTaskFactory> factories = new Int2ObjectHashMap(10);
    private final Node node;

    public VectorMessageTaskFactoryProvider(NodeEngine nodeEngine) {
        this.node = nodeEngine.getNode();
        this.initFactories();
    }

    public void initFactories() {
        this.factories.put(1774592, (cm, con) -> new AddVectorCollectionConfigMessageTask(cm, this.node, con));
        this.factories.put(0x240400, (cm, con) -> new VectorCollectionGetMessageTask(cm, this.node, con));
        this.factories.put(2359552, (cm, con) -> new VectorCollectionPutMessageTask(cm, this.node, con));
        this.factories.put(0x240200, (cm, con) -> new VectorCollectionPutIfAbsentMessageTask(cm, this.node, con));
        this.factories.put(2360064, (cm, con) -> new VectorCollectionPutAllMessageTask(cm, this.node, con));
        this.factories.put(2360832, (cm, con) -> new VectorCollectionSetMessageTask(cm, this.node, con));
        this.factories.put(2361088, (cm, con) -> new VectorCollectionDeleteMessageTask(cm, this.node, con));
        this.factories.put(2360576, (cm, con) -> new VectorCollectionRemoveMessageTask(cm, this.node, con));
        this.factories.put(2361344, (cm, con) -> new VectorCollectionSearchNearVectorMessageTask(cm, this.node, con));
        this.factories.put(2361600, (cm, con) -> new VectorCollectionOptimizeMessageTask(cm, this.node, con));
        this.factories.put(2361856, (cm, con) -> new VectorCollectionClearMessageTask(cm, this.node, con));
        this.factories.put(2362112, (cm, con) -> new VectorCollectionSizeMessageTask(cm, this.node, con));
    }

    @Override
    public Int2ObjectHashMap<MessageTaskFactory> getFactories() {
        return this.factories;
    }
}

