/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.VectorCollectionSizeCodec;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.security.permission.VectorCollectionPermission;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import com.hazelcast.vector.impl.ops.SizeOperationsFactory;
import com.hazelcast.vector.impl.protocol.task.AbstractVectorCollectionAllPartitionsMessageTask;
import com.hazelcast.vector.impl.stats.LocalVectorCollectionStatsImpl;
import java.security.Permission;
import java.util.Map;

public class VectorCollectionSizeMessageTask
extends AbstractVectorCollectionAllPartitionsMessageTask<String> {
    VectorCollectionSizeMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected String decodeClientMessage(ClientMessage clientMessage) {
        return VectorCollectionSizeCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return VectorCollectionSizeCodec.encodeResponse((Long)response);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new SizeOperationsFactory((String)this.parameters);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        long sum = map.values().stream().mapToLong(object -> (Long)object).sum();
        this.recordStats(LocalVectorCollectionStatsImpl::incrementSizeLatencyNanos);
        return sum;
    }

    @Override
    public String getDistributedObjectName() {
        return (String)this.parameters;
    }

    @Override
    public String getMethodName() {
        return "size";
    }

    @Override
    public Permission getRequiredPermission() {
        return new VectorCollectionPermission(this.getDistributedObjectName(), "read");
    }

    @Override
    public Object[] getParameters() {
        return null;
    }
}

