/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.ops;

import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.spi.impl.operationservice.BlockingBackupOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.vector.VectorValues;
import com.hazelcast.vector.impl.ops.BasePutOperation;
import java.util.function.Consumer;

public class SetBackupOperation
extends BasePutOperation
implements BackupOperation,
BlockingBackupOperation {
    private transient Consumer<Operation> backupOpAfterRun;

    public SetBackupOperation() {
    }

    public SetBackupOperation(String vectorCollectionName, Data key, Data userValue, VectorValues vectorValues) {
        super(vectorCollectionName, key, userValue, vectorValues);
    }

    @Override
    public void run() {
        this.storage.set(this.key, this.userValue, this.vectorValues);
        if (this.backupOpAfterRun != null) {
            this.backupOpAfterRun.accept(this);
        }
    }

    @Override
    public int getClassId() {
        return 30;
    }

    @Override
    public void setBackupOpAfterRun(Consumer<Operation> backupOpAfterRun) {
        this.backupOpAfterRun = backupOpAfterRun;
    }

    @Override
    public boolean shouldKeepAfterMigration(PartitionMigrationEvent event) {
        return event.getNewReplicaIndex() <= this.storage.getConfig().getTotalBackupCount();
    }
}

