/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.ops;

import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.spi.impl.operationservice.BlockingBackupOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import com.hazelcast.vector.impl.DataVectorDocument;
import com.hazelcast.vector.impl.ops.BaseMutatingOperation;
import com.hazelcast.vector.impl.ops.VectorEntries;
import java.io.IOException;
import java.util.function.Consumer;

public class PutAllBackupOperation
extends BaseMutatingOperation
implements PartitionAwareOperation,
BackupOperation,
BlockingBackupOperation {
    protected transient Consumer<Operation> backupOpAfterRun;
    private VectorEntries vectorEntries;

    public PutAllBackupOperation() {
    }

    public PutAllBackupOperation(String name, VectorEntries vectorEntries) {
        super(name);
        this.vectorEntries = vectorEntries;
    }

    @Override
    public void run() throws Exception {
        this.putAll();
        if (this.backupOpAfterRun != null) {
            this.backupOpAfterRun.accept(this);
        }
    }

    protected void putAll() {
        for (int currentIndex = 0; currentIndex < this.vectorEntries.size(); ++currentIndex) {
            DataVectorDocument value = this.vectorEntries.getDocument(currentIndex);
            this.storage.set(this.vectorEntries.getKey(currentIndex), value.getValue(), value.getVectors());
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.vectorEntries);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.vectorEntries = (VectorEntries)in.readObject();
    }

    @Override
    public int getClassId() {
        return 34;
    }

    @Override
    public void setBackupOpAfterRun(Consumer<Operation> backupOpAfterRun) {
        this.backupOpAfterRun = backupOpAfterRun;
    }

    @Override
    public boolean shouldKeepAfterMigration(PartitionMigrationEvent event) {
        return event.getNewReplicaIndex() <= this.storage.getConfig().getTotalBackupCount();
    }
}

