/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.ops;

import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.spi.impl.operationservice.BlockingBackupOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.vector.impl.ops.BaseOptimizeOperation;
import java.util.UUID;
import java.util.function.Consumer;

public class OptimizeBackupOperation
extends BaseOptimizeOperation
implements BackupOperation,
BlockingBackupOperation {
    public OptimizeBackupOperation() {
    }

    public OptimizeBackupOperation(UUID uuid, String vectorCollectionName, String indexName) {
        super(uuid, vectorCollectionName, indexName);
    }

    @Override
    public int getClassId() {
        return 31;
    }

    @Override
    public void setBackupOpAfterRun(Consumer<Operation> backupOpAfterRun) {
        this.backupOpAfterRun = backupOpAfterRun;
    }

    @Override
    public boolean shouldKeepAfterMigration(PartitionMigrationEvent event) {
        return event.getNewReplicaIndex() <= this.storage.getConfig().getTotalBackupCount();
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest(String.format("Backup operation failed %s %s", this.waited ? " (after waiting) " : " ", this), e);
        }
        super.onExecutionFailure(e);
    }
}

