/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.ops;

import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionAwareOperationFactory;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import com.hazelcast.vector.VectorDocument;
import com.hazelcast.vector.impl.VectorCollectionService;
import com.hazelcast.vector.impl.ops.MergeOperation;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class MergeOperationFactory
extends PartitionAwareOperationFactory {
    private String name;
    private List<SplitBrainMergeTypes.VectorCollectionMergeTypes<Object, VectorDocument<?>>>[] mergingEntries;
    private SplitBrainMergePolicy<VectorDocument<?>, SplitBrainMergeTypes.VectorCollectionMergeTypes<Object, VectorDocument<?>>, Object> mergePolicy;

    public MergeOperationFactory() {
    }

    public MergeOperationFactory(String name, int[] partitions, List<SplitBrainMergeTypes.VectorCollectionMergeTypes<Object, VectorDocument<?>>>[] mergingEntries, SplitBrainMergePolicy<VectorDocument<?>, SplitBrainMergeTypes.VectorCollectionMergeTypes<Object, VectorDocument<?>>, Object> mergePolicy) {
        this.name = name;
        this.partitions = partitions;
        this.mergingEntries = mergingEntries;
        this.mergePolicy = mergePolicy;
    }

    @Override
    public Operation createPartitionOperation(int partitionId) {
        for (int i = 0; i < this.partitions.length; ++i) {
            if (this.partitions[i] != partitionId) continue;
            return new MergeOperation(this.name, this.mergingEntries[i], this.mergePolicy);
        }
        throw new IllegalArgumentException("Unknown partitionId " + partitionId + " (" + Arrays.toString(this.partitions) + ")");
    }

    @Override
    public int getFactoryId() {
        return -100;
    }

    @Override
    public int getClassId() {
        return 36;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeIntArray(this.partitions);
        for (List<SplitBrainMergeTypes.VectorCollectionMergeTypes<Object, VectorDocument<?>>> list : this.mergingEntries) {
            SerializationUtil.writeList(list, out);
        }
        out.writeObject(this.mergePolicy);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.partitions = in.readIntArray();
        this.mergingEntries = new List[this.partitions.length];
        for (int i = 0; i < this.partitions.length; ++i) {
            this.mergingEntries[i] = SerializationUtil.readList(in);
        }
        this.mergePolicy = NamespaceUtil.callWithNamespace(in::readObject, this.name, VectorCollectionService::lookupNamespace);
    }
}

