/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.ops;

import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.spi.impl.operationservice.BlockingBackupOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import com.hazelcast.vector.impl.ops.BaseMutatingOperation;
import java.util.function.Consumer;

public class ClearBackupOperation
extends BaseMutatingOperation
implements PartitionAwareOperation,
BackupOperation,
BlockingBackupOperation {
    private transient Consumer<Operation> backupOpAfterRun;

    public ClearBackupOperation(String vectorCollectionName) {
        super(vectorCollectionName);
    }

    public ClearBackupOperation() {
    }

    @Override
    public void run() throws Exception {
        if (this.storage != null) {
            this.storage.clear();
        }
        if (this.backupOpAfterRun != null) {
            this.backupOpAfterRun.accept(this);
        }
    }

    @Override
    public int getClassId() {
        return 33;
    }

    @Override
    public void setBackupOpAfterRun(Consumer<Operation> backupOpAfterRun) {
        this.backupOpAfterRun = backupOpAfterRun;
    }

    @Override
    public boolean shouldKeepAfterMigration(PartitionMigrationEvent event) {
        return event.getNewReplicaIndex() <= this.storage.getConfig().getTotalBackupCount();
    }
}

