/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.ops;

import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.services.ServiceNamespaceAware;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.operationservice.AbstractNamedOperation;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.spi.impl.operationservice.BlockingOperation;
import com.hazelcast.spi.impl.operationservice.CallStatus;
import com.hazelcast.spi.impl.operationservice.WaitNotifyKey;
import com.hazelcast.vector.impl.VectorCollectionService;
import com.hazelcast.vector.impl.ops.BackupUtil;
import com.hazelcast.vector.impl.ops.VectorMutationWaitNotifyKey;
import com.hazelcast.vector.impl.storage.VectorCollectionStorage;

public abstract class BaseMutatingOperation
extends AbstractNamedOperation
implements ServiceNamespaceAware,
BlockingOperation {
    protected transient VectorCollectionStorage storage;
    protected transient boolean waited;
    private transient Object lockedIndex;

    protected BaseMutatingOperation() {
    }

    protected BaseMutatingOperation(String vectorCollectionName) {
        super(vectorCollectionName);
    }

    @Override
    public void beforeRun() {
        VectorCollectionService service = (VectorCollectionService)this.getService();
        this.storage = service.getStorage(this.getName(), this.getPartitionId());
    }

    @Override
    public CallStatus call() throws Exception {
        if (this.waited) {
            this.getLogger().finest("Executing after waiting %s", this);
        }
        return super.call();
    }

    @Override
    public boolean shouldWait() {
        this.lockedIndex = this.storage.findLockedIndex();
        if (this.lockedIndex != VectorCollectionStorage.NOT_LOCKED) {
            this.getLogger().finest("Index is locked, waiting with key %s, operation %s", this.getWaitKey(), this);
            this.waited = true;
        }
        return this.lockedIndex != VectorCollectionStorage.NOT_LOCKED;
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        assert (this.lockedIndex != VectorCollectionStorage.NOT_LOCKED) : "getWaitKey invoked before shouldWait or without locked index";
        return new VectorMutationWaitNotifyKey(this.name, (String)this.lockedIndex, this.getPartitionId());
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(new OperationTimeoutException("Timeout elapsed while waiting for index to be unlocked"));
    }

    @Override
    public String getServiceName() {
        return "hz:service:vector";
    }

    @Override
    public int getFactoryId() {
        return -100;
    }

    @Override
    public ServiceNamespace getServiceNamespace() {
        VectorCollectionService service = (VectorCollectionService)this.getService();
        return service.getObjectNamespace(this.getName());
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        if (this instanceof BackupOperation) {
            ILogger logger = this.getLogger();
            if (this.waited) {
                if (logger.isFineEnabled()) {
                    logger.fine(String.format("Backup operation failed, requesting replica sync: %s", this), e);
                }
                BackupUtil.markReplicaAsSyncRequiredForBackupOps(this);
            } else if (logger.isFinestEnabled()) {
                logger.finest(String.format("Backup operation failed %s", this), e);
            }
        }
        super.onExecutionFailure(e);
    }
}

