/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl;

import com.hazelcast.config.vector.VectorCollectionConfig;
import com.hazelcast.internal.memory.Measurable;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.RemoteService;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.vector.SearchOptions;
import com.hazelcast.vector.impl.VectorCollectionOptimizationManager;
import com.hazelcast.vector.impl.query.Searcher;
import com.hazelcast.vector.impl.stats.CollectionOnDemandStats;
import com.hazelcast.vector.impl.stats.LocalVectorCollectionStatsImpl;
import com.hazelcast.vector.impl.storage.VectorCollectionStorage;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface VectorCollectionService
extends ManagedService,
RemoteService,
Measurable {
    public static final String SERVICE_NAME = "hz:service:vector";

    public boolean isEnabled();

    @Nonnull
    public VectorCollectionStorage getStorage(String var1, int var2);

    @Nullable
    public VectorCollectionStorage getStorageOrNull(String var1, int var2);

    @Nonnull
    public VectorCollectionStorage createStorage(String var1, int var2);

    public void attachStorage(@Nonnull VectorCollectionStorage var1);

    public void destroyStorage(String var1, int var2);

    @Nonnull
    public Searcher getSearcher(String var1, SearchOptions var2);

    @Nonnull
    public LocalVectorCollectionStatsImpl getStatistics(String var1);

    @Nonnull
    public CollectionOnDemandStats getOnDemandStats(String var1);

    @Nonnull
    public Set<String> getAllExistingVectorCollectionNames();

    public ObjectNamespace getObjectNamespace(String var1);

    public VectorCollectionOptimizationManager getOptimizationManager();

    public static String lookupNamespace(@Nonnull NodeEngine engine, @Nonnull String collectionName) {
        if (!engine.getNamespaceService().isEnabled()) {
            return null;
        }
        VectorCollectionConfig collectionConfig = engine.getConfig().getVectorCollectionConfigOrNull(collectionName);
        return collectionConfig == null ? null : collectionConfig.getUserCodeNamespace();
    }
}

