/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector;

import com.hazelcast.config.vector.VectorCollectionConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spi.annotation.Beta;
import com.hazelcast.vector.SearchOptions;
import com.hazelcast.vector.SearchResults;
import com.hazelcast.vector.VectorDocument;
import com.hazelcast.vector.VectorValues;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Beta
public interface VectorCollection<K, V>
extends DistributedObject {
    public CompletionStage<VectorDocument<V>> getAsync(@Nonnull K var1);

    public CompletionStage<VectorDocument<V>> putAsync(@Nonnull K var1, @Nonnull VectorDocument<V> var2);

    public CompletionStage<Void> setAsync(@Nonnull K var1, @Nonnull VectorDocument<V> var2);

    public CompletionStage<VectorDocument<V>> putIfAbsentAsync(@Nonnull K var1, @Nonnull VectorDocument<V> var2);

    public CompletionStage<Void> putAllAsync(Map<? extends K, VectorDocument<V>> var1);

    public CompletionStage<VectorDocument<V>> removeAsync(K var1);

    public CompletionStage<Void> deleteAsync(K var1);

    public CompletionStage<Void> optimizeAsync(@Nullable String var1);

    default public CompletionStage<Void> optimizeAsync() {
        return this.optimizeAsync(null);
    }

    public CompletionStage<Void> clearAsync();

    public long size();

    public CompletionStage<SearchResults<K, V>> searchAsync(VectorValues var1, SearchOptions var2);

    public static <K, V> VectorCollection<K, V> getCollection(HazelcastInstance instance, VectorCollectionConfig collectionConfig) {
        String name = collectionConfig.getName();
        instance.getConfig().addVectorCollectionConfig(collectionConfig);
        return VectorCollection.getCollection(instance, name);
    }

    public static <K, V> VectorCollection<K, V> getCollection(HazelcastInstance instance, String name) {
        return (VectorCollection)instance.getDistributedObject("hz:service:vector", name);
    }
}

