/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.statistics.distribution;

import com.hazelcast.shaded.org.apache.commons.numbers.gamma.LogGamma;
import com.hazelcast.shaded.org.apache.commons.rng.UniformRandomProvider;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.ZigguratSampler;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.ArgumentUtils;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.ContinuousDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.DistributionException;

public final class WeibullDistribution
extends AbstractContinuousDistribution {
    private static final double SUPPORT_LO = 0.0;
    private static final double SUPPORT_HI = Double.POSITIVE_INFINITY;
    private final double shape;
    private final double scale;
    private final double shapeOverScale;
    private final double logShapeOverScale;

    private WeibullDistribution(double shape, double scale) {
        this.scale = scale;
        this.shape = shape;
        this.shapeOverScale = shape / scale;
        this.logShapeOverScale = Math.log(this.shapeOverScale);
    }

    public static WeibullDistribution of(double shape, double scale) {
        if (shape <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", shape);
        }
        if (scale <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", scale);
        }
        return new WeibullDistribution(shape, scale);
    }

    public double getShape() {
        return this.shape;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public double density(double x) {
        if (x <= 0.0 || x >= Double.POSITIVE_INFINITY) {
            if (x == 0.0 && this.shape <= 1.0) {
                return this.shape == 1.0 ? this.shapeOverScale : Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }
        double xscale = x / this.scale;
        double xscalepow = Math.pow(xscale, this.shape - 1.0);
        double xscalepowshape = xscalepow * xscale;
        return this.shapeOverScale * xscalepow * Math.exp(-xscalepowshape);
    }

    @Override
    public double logDensity(double x) {
        if (x <= 0.0 || x >= Double.POSITIVE_INFINITY) {
            if (x == 0.0 && this.shape <= 1.0) {
                return this.shape == 1.0 ? this.logShapeOverScale : Double.POSITIVE_INFINITY;
            }
            return Double.NEGATIVE_INFINITY;
        }
        double xscale = x / this.scale;
        double logxscalepow = Math.log(xscale) * (this.shape - 1.0);
        double xscalepowshape = Math.exp(logxscalepow) * xscale;
        return this.logShapeOverScale + logxscalepow - xscalepowshape;
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return -Math.expm1(-Math.pow(x / this.scale, this.shape));
    }

    @Override
    public double survivalProbability(double x) {
        if (x <= 0.0) {
            return 1.0;
        }
        return Math.exp(-Math.pow(x / this.scale, this.shape));
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        ArgumentUtils.checkProbability(p);
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.scale * Math.pow(-Math.log1p(-p), 1.0 / this.shape);
    }

    @Override
    public double inverseSurvivalProbability(double p) {
        ArgumentUtils.checkProbability(p);
        if (p == 1.0) {
            return 0.0;
        }
        if (p == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.scale * Math.pow(-Math.log(p), 1.0 / this.shape);
    }

    @Override
    public double getMean() {
        double sh = this.getShape();
        double sc = this.getScale();
        return sh == 1.0 ? sc : sc * Math.exp(LogGamma.value(1.0 + 1.0 / sh));
    }

    @Override
    public double getVariance() {
        double sh = this.getShape();
        double sc = this.getScale();
        double mn = this.getMean();
        return sh == 1.0 ? sc * sc : sc * sc * Math.exp(LogGamma.value(1.0 + 2.0 / sh)) - mn * mn;
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
        if (this.shape == 1.0) {
            return () -> ((ZigguratSampler.Exponential)ZigguratSampler.Exponential.of((UniformRandomProvider)rng, (double)this.scale)).sample();
        }
        return super.createSampler(rng);
    }
}

