/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.statistics.distribution;

import com.hazelcast.shaded.org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.ArgumentUtils;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.DistributionException;

public final class TriangularDistribution
extends AbstractContinuousDistribution {
    private final double a;
    private final double b;
    private final double c;
    private final double divisor1;
    private final double divisor2;
    private final double cdfMode;
    private final double sfMode;

    private TriangularDistribution(double a2, double c, double b) {
        this.a = a2;
        this.c = c;
        this.b = b;
        this.divisor1 = (b - a2) * (c - a2);
        this.divisor2 = (b - a2) * (b - c);
        this.cdfMode = (c - a2) / (b - a2);
        this.sfMode = (b - c) / (b - a2);
    }

    public static TriangularDistribution of(double a2, double c, double b) {
        if (a2 >= b) {
            throw new DistributionException("Lower bound %s >= upper bound %s", a2, b);
        }
        if (c < a2) {
            throw new DistributionException("%s < %s", c, a2);
        }
        if (c > b) {
            throw new DistributionException("%s > %s", c, b);
        }
        return new TriangularDistribution(a2, c, b);
    }

    public double getMode() {
        return this.c;
    }

    @Override
    public double density(double x) {
        if (x < this.a) {
            return 0.0;
        }
        if (x < this.c) {
            double divident = 2.0 * (x - this.a);
            return divident / this.divisor1;
        }
        if (x == this.c) {
            return 2.0 / (this.b - this.a);
        }
        if (x <= this.b) {
            double divident = 2.0 * (this.b - x);
            return divident / this.divisor2;
        }
        return 0.0;
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= this.a) {
            return 0.0;
        }
        if (x < this.c) {
            double divident = (x - this.a) * (x - this.a);
            return divident / this.divisor1;
        }
        if (x == this.c) {
            return this.cdfMode;
        }
        if (x < this.b) {
            double divident = (this.b - x) * (this.b - x);
            return 1.0 - divident / this.divisor2;
        }
        return 1.0;
    }

    @Override
    public double survivalProbability(double x) {
        if (x <= this.a) {
            return 1.0;
        }
        if (x < this.c) {
            double divident = (x - this.a) * (x - this.a);
            return 1.0 - divident / this.divisor1;
        }
        if (x == this.c) {
            return this.sfMode;
        }
        if (x < this.b) {
            double divident = (this.b - x) * (this.b - x);
            return divident / this.divisor2;
        }
        return 0.0;
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        ArgumentUtils.checkProbability(p);
        if (p == 0.0) {
            return this.a;
        }
        if (p == 1.0) {
            return this.b;
        }
        if (p < this.cdfMode) {
            return this.a + Math.sqrt(p * this.divisor1);
        }
        return this.b - Math.sqrt((1.0 - p) * this.divisor2);
    }

    @Override
    public double inverseSurvivalProbability(double p) {
        ArgumentUtils.checkProbability(p);
        if (p == 1.0) {
            return this.a;
        }
        if (p == 0.0) {
            return this.b;
        }
        if (p >= this.sfMode) {
            return this.a + Math.sqrt((1.0 - p) * this.divisor1);
        }
        return this.b - Math.sqrt(p * this.divisor2);
    }

    @Override
    public double getMean() {
        return (this.a + this.b + this.c) / 3.0;
    }

    @Override
    public double getVariance() {
        return (this.a * this.a + this.b * this.b + this.c * this.c - this.a * this.b - this.a * this.c - this.b * this.c) / 18.0;
    }

    @Override
    public double getSupportLowerBound() {
        return this.a;
    }

    @Override
    public double getSupportUpperBound() {
        return this.b;
    }
}

