/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.statistics.distribution;

import com.hazelcast.shaded.org.apache.commons.numbers.combinatorics.BinomialCoefficientDouble;
import com.hazelcast.shaded.org.apache.commons.numbers.combinatorics.LogBinomialCoefficient;
import com.hazelcast.shaded.org.apache.commons.numbers.gamma.RegularizedBeta;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.AbstractDiscreteDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.DistributionException;

public final class PascalDistribution
extends AbstractDiscreteDistribution {
    private final int numberOfSuccesses;
    private final double probabilityOfSuccess;
    private final double logProbabilityOfSuccessByNumOfSuccesses;
    private final double log1mProbabilityOfSuccess;
    private final double probabilityOfSuccessPowNumOfSuccesses;

    private PascalDistribution(int r, double p) {
        this.numberOfSuccesses = r;
        this.probabilityOfSuccess = p;
        this.logProbabilityOfSuccessByNumOfSuccesses = Math.log(p) * (double)this.numberOfSuccesses;
        this.log1mProbabilityOfSuccess = Math.log1p(-p);
        this.probabilityOfSuccessPowNumOfSuccesses = Math.pow(this.probabilityOfSuccess, this.numberOfSuccesses);
    }

    public static PascalDistribution of(int r, double p) {
        if (r <= 0) {
            throw new DistributionException("Number %s is not greater than 0", r);
        }
        if (p <= 0.0 || p > 1.0) {
            throw new DistributionException("Not a non-zero probability: %s is out of range (0, 1]", p);
        }
        return new PascalDistribution(r, p);
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    public double probability(int x) {
        if (x <= 0) {
            return x == 0 ? this.probabilityOfSuccessPowNumOfSuccesses : 0.0;
        }
        int n = x + this.numberOfSuccesses - 1;
        if (n < 0) {
            return 0.0;
        }
        return BinomialCoefficientDouble.value((int)n, (int)(this.numberOfSuccesses - 1)) * this.probabilityOfSuccessPowNumOfSuccesses * Math.pow(1.0 - this.probabilityOfSuccess, x);
    }

    @Override
    public double logProbability(int x) {
        if (x <= 0) {
            return x == 0 ? this.logProbabilityOfSuccessByNumOfSuccesses : Double.NEGATIVE_INFINITY;
        }
        int n = x + this.numberOfSuccesses - 1;
        if (n < 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return LogBinomialCoefficient.value((int)n, (int)(this.numberOfSuccesses - 1)) + this.logProbabilityOfSuccessByNumOfSuccesses + this.log1mProbabilityOfSuccess * (double)x;
    }

    @Override
    public double cumulativeProbability(int x) {
        if (x < 0) {
            return 0.0;
        }
        return RegularizedBeta.value(this.probabilityOfSuccess, this.numberOfSuccesses, (double)x + 1.0);
    }

    @Override
    public double survivalProbability(int x) {
        if (x < 0) {
            return 1.0;
        }
        return RegularizedBeta.complement(this.probabilityOfSuccess, this.numberOfSuccesses, (double)x + 1.0);
    }

    @Override
    public double getMean() {
        double p = this.getProbabilityOfSuccess();
        double r = this.getNumberOfSuccesses();
        return r * (1.0 - p) / p;
    }

    @Override
    public double getVariance() {
        double p = this.getProbabilityOfSuccess();
        double r = this.getNumberOfSuccesses();
        return r * (1.0 - p) / (p * p);
    }

    @Override
    public int getSupportLowerBound() {
        return 0;
    }

    @Override
    public int getSupportUpperBound() {
        return this.probabilityOfSuccess < 1.0 ? Integer.MAX_VALUE : 0;
    }
}

