/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.statistics.distribution;

import com.hazelcast.shaded.org.apache.commons.numbers.gamma.ErfDifference;
import com.hazelcast.shaded.org.apache.commons.numbers.gamma.Erfc;
import com.hazelcast.shaded.org.apache.commons.numbers.gamma.InverseErfc;
import com.hazelcast.shaded.org.apache.commons.rng.UniformRandomProvider;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.GaussianSampler;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.ZigguratSampler;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.ArgumentUtils;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.ContinuousDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.DistributionException;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.ExtendedPrecision;

public final class NormalDistribution
extends AbstractContinuousDistribution {
    private final double mean;
    private final double standardDeviation;
    private final double logStandardDeviationPlusHalfLog2Pi;
    private final double sdSqrt2;
    private final double sdSqrt2pi;

    private NormalDistribution(double mean, double sd) {
        this.mean = mean;
        this.standardDeviation = sd;
        this.logStandardDeviationPlusHalfLog2Pi = Math.log(sd) + 0.9189385332046728;
        this.sdSqrt2 = ExtendedPrecision.sqrt2xx(sd);
        this.sdSqrt2pi = ExtendedPrecision.xsqrt2pi(sd);
    }

    public static NormalDistribution of(double mean, double sd) {
        if (sd > 0.0) {
            return new NormalDistribution(mean, sd);
        }
        throw new DistributionException("Number %s is not greater than 0", sd);
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    @Override
    public double density(double x) {
        double z = (x - this.mean) / this.standardDeviation;
        return ExtendedPrecision.expmhxx(z) / this.sdSqrt2pi;
    }

    @Override
    public double probability(double x0, double x1) {
        if (x0 > x1) {
            throw new DistributionException("Lower bound %s > upper bound %s", x0, x1);
        }
        double v0 = (x0 - this.mean) / this.sdSqrt2;
        double v1 = (x1 - this.mean) / this.sdSqrt2;
        return 0.5 * ErfDifference.value(v0, v1);
    }

    @Override
    public double logDensity(double x) {
        double z = (x - this.mean) / this.standardDeviation;
        return -0.5 * z * z - this.logStandardDeviationPlusHalfLog2Pi;
    }

    @Override
    public double cumulativeProbability(double x) {
        double dev = x - this.mean;
        return 0.5 * Erfc.value(-dev / this.sdSqrt2);
    }

    @Override
    public double survivalProbability(double x) {
        double dev = x - this.mean;
        return 0.5 * Erfc.value(dev / this.sdSqrt2);
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        ArgumentUtils.checkProbability(p);
        return this.mean - this.sdSqrt2 * InverseErfc.value(2.0 * p);
    }

    @Override
    public double inverseSurvivalProbability(double p) {
        ArgumentUtils.checkProbability(p);
        return this.mean + this.sdSqrt2 * InverseErfc.value(2.0 * p);
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getVariance() {
        double s = this.getStandardDeviation();
        return s * s;
    }

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return () -> ((SharedStateContinuousSampler)GaussianSampler.of((NormalizedGaussianSampler)ZigguratSampler.NormalizedGaussian.of((UniformRandomProvider)rng), (double)this.mean, (double)this.standardDeviation)).sample();
    }
}

