/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.statistics.distribution;

import com.hazelcast.shaded.org.apache.commons.numbers.gamma.Erf;
import com.hazelcast.shaded.org.apache.commons.numbers.gamma.ErfDifference;
import com.hazelcast.shaded.org.apache.commons.numbers.gamma.Erfc;
import com.hazelcast.shaded.org.apache.commons.numbers.gamma.InverseErf;
import com.hazelcast.shaded.org.apache.commons.numbers.gamma.InverseErfc;
import com.hazelcast.shaded.org.apache.commons.rng.UniformRandomProvider;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.GaussianSampler;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.ZigguratSampler;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.ArgumentUtils;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.ContinuousDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.DistributionException;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.ExtendedPrecision;

public abstract class FoldedNormalDistribution
extends AbstractContinuousDistribution {
    final double sigma;
    final double sigmaSqrt2;
    final double sigmaSqrt2pi;

    FoldedNormalDistribution(double sigma) {
        this.sigma = sigma;
        this.sigmaSqrt2 = ExtendedPrecision.sqrt2xx(sigma);
        this.sigmaSqrt2pi = ExtendedPrecision.xsqrt2pi(sigma);
    }

    public static FoldedNormalDistribution of(double mu, double sigma) {
        if (sigma > 0.0) {
            if (mu == 0.0) {
                return new HalfNormalDistribution(sigma);
            }
            return new RegularFoldedNormalDistribution(mu, sigma);
        }
        throw new DistributionException("Number %s is not greater than 0", sigma);
    }

    public abstract double getMu();

    public double getSigma() {
        return this.sigma;
    }

    @Override
    public abstract double getMean();

    @Override
    public abstract double getVariance();

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    private static class HalfNormalDistribution
    extends FoldedNormalDistribution {
        private static final double VAR = 0.3633802276324187;
        private final double logSigmaPlusHalfLog2Pi;

        HalfNormalDistribution(double sigma) {
            super(sigma);
            this.logSigmaPlusHalfLog2Pi = Math.log(sigma) + 0.9189385332046728;
        }

        @Override
        public double getMu() {
            return 0.0;
        }

        @Override
        public double density(double x) {
            if (x < 0.0) {
                return 0.0;
            }
            return 2.0 * ExtendedPrecision.expmhxx(x / this.sigma) / this.sigmaSqrt2pi;
        }

        @Override
        public double probability(double x0, double x1) {
            if (x0 > x1) {
                throw new DistributionException("Lower bound %s > upper bound %s", x0, x1);
            }
            if (x0 <= 0.0) {
                return this.cumulativeProbability(x1);
            }
            return ErfDifference.value(x0 / this.sigmaSqrt2, x1 / this.sigmaSqrt2);
        }

        @Override
        public double logDensity(double x) {
            if (x < 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            double z = x / this.sigma;
            return 0.6931471805599453 - 0.5 * z * z - this.logSigmaPlusHalfLog2Pi;
        }

        @Override
        public double cumulativeProbability(double x) {
            if (x <= 0.0) {
                return 0.0;
            }
            return Erf.value(x / this.sigmaSqrt2);
        }

        @Override
        public double survivalProbability(double x) {
            if (x <= 0.0) {
                return 1.0;
            }
            return Erfc.value(x / this.sigmaSqrt2);
        }

        @Override
        public double inverseCumulativeProbability(double p) {
            ArgumentUtils.checkProbability(p);
            return 0.0 + this.sigmaSqrt2 * InverseErf.value(p);
        }

        @Override
        public double inverseSurvivalProbability(double p) {
            ArgumentUtils.checkProbability(p);
            return this.sigmaSqrt2 * InverseErfc.value(p);
        }

        @Override
        public double getMean() {
            return this.sigma * 0.7978845608028654;
        }

        @Override
        public double getVariance() {
            return this.sigma * this.sigma * 0.3633802276324187;
        }

        @Override
        public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
            ZigguratSampler.NormalizedGaussian s = ZigguratSampler.NormalizedGaussian.of((UniformRandomProvider)rng);
            return () -> this.lambda$createSampler$0((SharedStateContinuousSampler)s);
        }

        private /* synthetic */ double lambda$createSampler$0(SharedStateContinuousSampler s) {
            return Math.abs(s.sample() * this.sigma);
        }
    }

    private static class RegularFoldedNormalDistribution
    extends FoldedNormalDistribution {
        private final double mu;
        private final double mean;
        private final double variance;

        RegularFoldedNormalDistribution(double mu, double sigma) {
            super(sigma);
            this.mu = mu;
            double a2 = mu / this.sigmaSqrt2;
            this.mean = sigma * 0.7978845608028654 * Math.exp(-a2 * a2) + mu * Erf.value(a2);
            this.variance = mu * mu + sigma * sigma - this.mean * this.mean;
        }

        @Override
        public double getMu() {
            return this.mu;
        }

        @Override
        public double density(double x) {
            if (x < 0.0) {
                return 0.0;
            }
            double vm = (x - this.mu) / this.sigma;
            double vp = (x + this.mu) / this.sigma;
            return (ExtendedPrecision.expmhxx(vm) + ExtendedPrecision.expmhxx(vp)) / this.sigmaSqrt2pi;
        }

        @Override
        public double probability(double x0, double x1) {
            if (x0 > x1) {
                throw new DistributionException("Lower bound %s > upper bound %s", x0, x1);
            }
            if (x0 <= 0.0) {
                return this.cumulativeProbability(x1);
            }
            double v0m = (x0 - this.mu) / this.sigmaSqrt2;
            double v1m = (x1 - this.mu) / this.sigmaSqrt2;
            double v0p = (x0 + this.mu) / this.sigmaSqrt2;
            double v1p = (x1 + this.mu) / this.sigmaSqrt2;
            return 0.5 * (ErfDifference.value(v0m, v1m) + ErfDifference.value(v0p, v1p));
        }

        @Override
        public double cumulativeProbability(double x) {
            if (x <= 0.0) {
                return 0.0;
            }
            return 0.5 * (Erf.value((x - this.mu) / this.sigmaSqrt2) + Erf.value((x + this.mu) / this.sigmaSqrt2));
        }

        @Override
        public double survivalProbability(double x) {
            if (x <= 0.0) {
                return 1.0;
            }
            return 0.5 * (Erfc.value((x - this.mu) / this.sigmaSqrt2) + Erfc.value((x + this.mu) / this.sigmaSqrt2));
        }

        @Override
        public double getMean() {
            return this.mean;
        }

        @Override
        public double getVariance() {
            return this.variance;
        }

        @Override
        public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
            SharedStateContinuousSampler s = GaussianSampler.of((NormalizedGaussianSampler)ZigguratSampler.NormalizedGaussian.of((UniformRandomProvider)rng), (double)this.mu, (double)this.sigma);
            return () -> Math.abs(s.sample());
        }
    }
}

