/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.numbers.gamma;

final class SpecialMath {
    private static final double X_MIN = -1.0;
    private static final double X_LOW = -0.79149064;
    private static final double X_HIGH = 1.0;
    private static final double TWO_POW_M6 = 0.015625;
    private static final double TWO_POW_M12 = 2.44140625E-4;
    private static final double TWO_POW_M20 = 9.5367431640625E-7;
    private static final double TWO_POW_M53 = (double)1.110223E-16f;

    private SpecialMath() {
    }

    static double log1pmx(double x) {
        double sum2;
        if (x <= -1.0) {
            return x == -1.0 ? Double.NEGATIVE_INFINITY : Double.NaN;
        }
        if (x < -0.79149064 || x > 1.0) {
            return Math.log1p(x) - x;
        }
        double a2 = Math.abs(x);
        if (a2 < 0.015625) {
            return SpecialMath.log1pmxSmall(x, a2);
        }
        double z = x / (2.0 + x);
        double zz = z * z;
        double sum = 0.3333333333333333;
        double numerator = 1.0;
        int denominator = 3;
        while ((sum2 = sum + (numerator *= zz) / (double)(denominator += 2)) != sum) {
            sum = sum2;
        }
        return z * (2.0 * zz * sum - x);
    }

    private static double log1pmxSmall(double x, double a2) {
        double x2 = x * x;
        if (a2 < (double)1.110223E-16f) {
            return 0.0 - x2 / 2.0;
        }
        double x4 = x2 * x2;
        if (a2 < 9.5367431640625E-7) {
            return x * x4 / 5.0 - x4 / 4.0 + x * x2 / 3.0 - x2 / 2.0;
        }
        if (a2 < 2.44140625E-4) {
            return x * x2 * x4 / 7.0 - x2 * x4 / 6.0 + x * x4 / 5.0 - x4 / 4.0 + x * x2 / 3.0 - x2 / 2.0;
        }
        double x8 = x4 * x4;
        return x * x2 * x8 / 11.0 - x2 * x8 / 10.0 + x * x8 / 9.0 - x8 / 8.0 + x * x2 * x4 / 7.0 - x2 * x4 / 6.0 + x * x4 / 5.0 - x4 / 4.0 + x * x2 / 3.0 - x2 / 2.0;
    }
}

