/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.agrona.concurrent.broadcast;

import com.hazelcast.shaded.org.agrona.BitUtil;
import com.hazelcast.shaded.org.agrona.MutableDirectBuffer;
import com.hazelcast.shaded.org.agrona.concurrent.AtomicBuffer;
import com.hazelcast.shaded.org.agrona.concurrent.MemoryAccess;
import com.hazelcast.shaded.org.agrona.concurrent.broadcast.BroadcastBufferDescriptor;
import com.hazelcast.shaded.org.agrona.concurrent.broadcast.RecordDescriptor;
import java.util.concurrent.atomic.AtomicLong;

public class BroadcastReceiver {
    private long cursor;
    private long nextRecord;
    private int recordOffset;
    private final int capacity;
    private final int tailIntentCounterIndex;
    private final int tailCounterIndex;
    private final int latestCounterIndex;
    private final AtomicBuffer buffer;
    private final AtomicLong lappedCount = new AtomicLong();

    public BroadcastReceiver(AtomicBuffer buffer) {
        this.buffer = buffer;
        this.capacity = buffer.capacity() - BroadcastBufferDescriptor.TRAILER_LENGTH;
        BroadcastBufferDescriptor.checkCapacity(this.capacity);
        buffer.verifyAlignment();
        this.tailIntentCounterIndex = this.capacity + BroadcastBufferDescriptor.TAIL_INTENT_COUNTER_OFFSET;
        this.tailCounterIndex = this.capacity + BroadcastBufferDescriptor.TAIL_COUNTER_OFFSET;
        this.latestCounterIndex = this.capacity + BroadcastBufferDescriptor.LATEST_COUNTER_OFFSET;
        this.cursor = this.nextRecord = buffer.getLongVolatile(this.latestCounterIndex);
        this.recordOffset = (int)this.cursor & this.capacity - 1;
    }

    public int capacity() {
        return this.capacity;
    }

    public long lappedCount() {
        return this.lappedCount.get();
    }

    public int typeId() {
        return this.buffer.getInt(RecordDescriptor.typeOffset(this.recordOffset));
    }

    public int offset() {
        return RecordDescriptor.msgOffset(this.recordOffset);
    }

    public int length() {
        return this.buffer.getInt(RecordDescriptor.lengthOffset(this.recordOffset)) - 8;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public boolean receiveNext() {
        long cursor;
        boolean isAvailable = false;
        AtomicBuffer buffer = this.buffer;
        long tail = buffer.getLongVolatile(this.tailCounterIndex);
        if (tail > (cursor = this.nextRecord)) {
            int capacity = this.capacity;
            int recordOffset = (int)cursor & capacity - 1;
            if (!this.validate(cursor, buffer, capacity)) {
                this.lappedCount.lazySet(this.lappedCount.get() + 1L);
                cursor = buffer.getLongVolatile(this.latestCounterIndex);
                recordOffset = (int)cursor & capacity - 1;
            }
            this.cursor = cursor;
            this.nextRecord = cursor + (long)BitUtil.align(buffer.getInt(RecordDescriptor.lengthOffset(recordOffset)), 8);
            if (-1 == buffer.getInt(RecordDescriptor.typeOffset(recordOffset))) {
                recordOffset = 0;
                this.cursor = this.nextRecord;
                this.nextRecord += (long)BitUtil.align(buffer.getInt(RecordDescriptor.lengthOffset(recordOffset)), 8);
            }
            this.recordOffset = recordOffset;
            isAvailable = true;
        }
        return isAvailable;
    }

    public boolean validate() {
        MemoryAccess.acquireFence();
        return this.validate(this.cursor, this.buffer, this.capacity);
    }

    private boolean validate(long cursor, AtomicBuffer buffer, int capacity) {
        return cursor + (long)capacity > buffer.getLongVolatile(this.tailIntentCounterIndex);
    }
}

