/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.agrona.concurrent;

import com.hazelcast.shaded.org.agrona.ErrorHandler;
import com.hazelcast.shaded.org.agrona.concurrent.Agent;
import com.hazelcast.shaded.org.agrona.concurrent.AgentTerminationException;
import com.hazelcast.shaded.org.agrona.concurrent.status.AtomicCounter;
import java.nio.channels.ClosedByInterruptException;
import java.util.Objects;

public class AgentInvoker
implements AutoCloseable {
    private boolean isClosed = false;
    private boolean isStarted = false;
    private boolean isRunning = false;
    private final AtomicCounter errorCounter;
    private final ErrorHandler errorHandler;
    private final Agent agent;

    public AgentInvoker(ErrorHandler errorHandler, AtomicCounter errorCounter, Agent agent) {
        Objects.requireNonNull(errorHandler, "errorHandler");
        Objects.requireNonNull(agent, "agent");
        this.errorHandler = errorHandler;
        this.errorCounter = errorCounter;
        this.agent = agent;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Agent agent() {
        return this.agent;
    }

    public void start() {
        try {
            if (!this.isStarted) {
                this.isStarted = true;
                this.agent.onStart();
                this.isRunning = true;
            }
        }
        catch (Throwable t) {
            this.errorHandler.onError(t);
            if (t instanceof Error) {
                throw (Error)t;
            }
            this.close();
        }
    }

    public int invoke() {
        int workCount;
        block8: {
            workCount = 0;
            if (this.isRunning) {
                try {
                    workCount = this.agent.doWork();
                    if (workCount <= 0 && Thread.currentThread().isInterrupted()) {
                        this.isRunning = false;
                    }
                }
                catch (InterruptedException | ClosedByInterruptException ignore) {
                    this.close();
                    Thread.currentThread().interrupt();
                }
                catch (AgentTerminationException ex) {
                    this.isRunning = false;
                    this.handleError(ex);
                    this.close();
                }
                catch (Throwable t) {
                    boolean isInterrupted = Thread.currentThread().isInterrupted();
                    if (isInterrupted) {
                        this.isRunning = false;
                    }
                    this.handleError(t);
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    if (!isInterrupted && !Thread.currentThread().isInterrupted()) break block8;
                    this.isRunning = false;
                    this.close();
                }
            }
        }
        return workCount;
    }

    @Override
    public final void close() {
        block3: {
            try {
                if (!this.isClosed) {
                    this.isRunning = false;
                    this.isClosed = true;
                    this.agent.onClose();
                }
            }
            catch (Throwable t) {
                this.errorHandler.onError(t);
                if (!(t instanceof Error)) break block3;
                throw (Error)t;
            }
        }
    }

    private void handleError(Throwable throwable) {
        if (null != this.errorCounter && this.isRunning && !this.errorCounter.isClosed()) {
            this.errorCounter.increment();
        }
        this.errorHandler.onError(throwable);
    }
}

