/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.agrona;

import com.hazelcast.shaded.org.agrona.BitUtil;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class DeadlineTimerWheel {
    public static final long NULL_DEADLINE = Long.MAX_VALUE;
    private static final int INITIAL_TICK_ALLOCATION = 16;
    private final long tickResolution;
    private long startTime;
    private long currentTick;
    private long timerCount;
    private final int ticksPerWheel;
    private final int tickMask;
    private final int resolutionBitsToShift;
    private int tickAllocation;
    private int allocationBitsToShift;
    private int pollIndex;
    private final TimeUnit timeUnit;
    private long[] wheel;

    public DeadlineTimerWheel(TimeUnit timeUnit, long startTime, long tickResolution, int ticksPerWheel) {
        this(timeUnit, startTime, tickResolution, ticksPerWheel, 16);
    }

    public DeadlineTimerWheel(TimeUnit timeUnit, long startTime, long tickResolution, int ticksPerWheel, int initialTickAllocation) {
        DeadlineTimerWheel.checkTicksPerWheel(ticksPerWheel);
        DeadlineTimerWheel.checkResolution(tickResolution);
        DeadlineTimerWheel.checkInitialTickAllocation(initialTickAllocation);
        this.timeUnit = timeUnit;
        this.ticksPerWheel = ticksPerWheel;
        this.tickAllocation = initialTickAllocation;
        this.tickMask = ticksPerWheel - 1;
        this.tickResolution = tickResolution;
        this.resolutionBitsToShift = Long.numberOfTrailingZeros(tickResolution);
        this.allocationBitsToShift = Integer.numberOfTrailingZeros(initialTickAllocation);
        this.startTime = startTime;
        this.wheel = new long[ticksPerWheel * initialTickAllocation];
        Arrays.fill(this.wheel, Long.MAX_VALUE);
    }

    public TimeUnit timeUnit() {
        return this.timeUnit;
    }

    public long tickResolution() {
        return this.tickResolution;
    }

    public int ticksPerWheel() {
        return this.ticksPerWheel;
    }

    public long startTime() {
        return this.startTime;
    }

    public long timerCount() {
        return this.timerCount;
    }

    public void resetStartTime(long startTime) {
        if (this.timerCount > 0L) {
            throw new IllegalStateException("can not reset startTime with active timers");
        }
        this.startTime = startTime;
        this.currentTick = 0L;
        this.pollIndex = 0;
    }

    public long currentTickTime() {
        return this.currentTickTime0();
    }

    public void currentTickTime(long now) {
        this.currentTick = Math.max(now - this.startTime >> this.resolutionBitsToShift, this.currentTick);
    }

    public void clear() {
        long remainingTimers = this.timerCount;
        if (0L == remainingTimers) {
            return;
        }
        int length = this.wheel.length;
        for (int i = 0; i < length; ++i) {
            if (Long.MAX_VALUE == this.wheel[i]) continue;
            this.wheel[i] = Long.MAX_VALUE;
            if (--remainingTimers > 0L) continue;
            this.timerCount = 0L;
            return;
        }
    }

    public long scheduleTimer(long deadline) {
        long deadlineTick = Math.max(deadline - this.startTime >> this.resolutionBitsToShift, this.currentTick);
        int spokeIndex = (int)(deadlineTick & (long)this.tickMask);
        int tickStartIndex = spokeIndex << this.allocationBitsToShift;
        for (int i = 0; i < this.tickAllocation; ++i) {
            int index = tickStartIndex + i;
            if (Long.MAX_VALUE != this.wheel[index]) continue;
            this.wheel[index] = deadline;
            ++this.timerCount;
            return DeadlineTimerWheel.timerIdForSlot(spokeIndex, i);
        }
        return this.increaseCapacity(deadline, spokeIndex);
    }

    public boolean cancelTimer(long timerId) {
        int spokeIndex = DeadlineTimerWheel.tickForTimerId(timerId);
        int tickIndex = DeadlineTimerWheel.indexInTickArray(timerId);
        int wheelIndex = (spokeIndex << this.allocationBitsToShift) + tickIndex;
        if (spokeIndex < this.ticksPerWheel && tickIndex < this.tickAllocation && Long.MAX_VALUE != this.wheel[wheelIndex]) {
            this.wheel[wheelIndex] = Long.MAX_VALUE;
            --this.timerCount;
            return true;
        }
        return false;
    }

    public int poll(long now, TimerHandler handler, int expiryLimit) {
        int timersExpired = 0;
        if (this.timerCount > 0L) {
            int spokeIndex = (int)this.currentTick & this.tickMask;
            int length = this.tickAllocation;
            for (int i = 0; i < length && expiryLimit > timersExpired; ++i) {
                int wheelIndex = (spokeIndex << this.allocationBitsToShift) + this.pollIndex;
                long deadline = this.wheel[wheelIndex];
                if (now >= deadline) {
                    this.wheel[wheelIndex] = Long.MAX_VALUE;
                    --this.timerCount;
                    ++timersExpired;
                    if (!handler.onTimerExpiry(this.timeUnit, now, DeadlineTimerWheel.timerIdForSlot(spokeIndex, this.pollIndex))) {
                        this.wheel[wheelIndex] = deadline;
                        ++this.timerCount;
                        return --timersExpired;
                    }
                }
                this.pollIndex = this.pollIndex + 1 >= length ? 0 : this.pollIndex + 1;
            }
            if (expiryLimit > timersExpired && now >= this.currentTickTime0()) {
                ++this.currentTick;
                this.pollIndex = 0;
            } else if (this.pollIndex >= this.tickAllocation) {
                this.pollIndex = 0;
            }
        } else if (now >= this.currentTickTime0()) {
            ++this.currentTick;
            this.pollIndex = 0;
        }
        return timersExpired;
    }

    public void forEach(TimerConsumer consumer) {
        long timersRemaining = this.timerCount;
        int length = this.wheel.length;
        for (int i = 0; i < length; ++i) {
            long deadline = this.wheel[i];
            if (Long.MAX_VALUE == deadline) continue;
            consumer.accept(deadline, DeadlineTimerWheel.timerIdForSlot(i >> this.allocationBitsToShift, i & this.tickMask));
            if (--timersRemaining > 0L) continue;
            return;
        }
    }

    public long deadline(long timerId) {
        int spokeIndex = DeadlineTimerWheel.tickForTimerId(timerId);
        int tickIndex = DeadlineTimerWheel.indexInTickArray(timerId);
        int wheelIndex = (spokeIndex << this.allocationBitsToShift) + tickIndex;
        if (spokeIndex < this.ticksPerWheel && tickIndex < this.tickAllocation) {
            return this.wheel[wheelIndex];
        }
        return Long.MAX_VALUE;
    }

    private long currentTickTime0() {
        return (this.currentTick + 1L << this.resolutionBitsToShift) + this.startTime;
    }

    private long increaseCapacity(long deadline, int spokeIndex) {
        int newTickAllocation = this.tickAllocation << 1;
        int newAllocationBitsToShift = Integer.numberOfTrailingZeros(newTickAllocation);
        long newCapacity = (long)this.ticksPerWheel * (long)newTickAllocation;
        if (newCapacity > 0x40000000L) {
            throw new IllegalStateException("max capacity reached at tickAllocation=" + this.tickAllocation);
        }
        long[] newWheel = new long[(int)newCapacity];
        Arrays.fill(newWheel, Long.MAX_VALUE);
        for (int j = 0; j < this.ticksPerWheel; ++j) {
            int oldTickStartIndex = j << this.allocationBitsToShift;
            int newTickStartIndex = j << newAllocationBitsToShift;
            System.arraycopy(this.wheel, oldTickStartIndex, newWheel, newTickStartIndex, this.tickAllocation);
        }
        newWheel[(spokeIndex << newAllocationBitsToShift) + this.tickAllocation] = deadline;
        long timerId = DeadlineTimerWheel.timerIdForSlot(spokeIndex, this.tickAllocation);
        ++this.timerCount;
        this.tickAllocation = newTickAllocation;
        this.allocationBitsToShift = newAllocationBitsToShift;
        this.wheel = newWheel;
        return timerId;
    }

    private static long timerIdForSlot(int tickOnWheel, int tickArrayIndex) {
        return (long)tickOnWheel << 32 | (long)tickArrayIndex;
    }

    private static int tickForTimerId(long timerId) {
        return (int)(timerId >> 32);
    }

    private static int indexInTickArray(long timerId) {
        return (int)timerId;
    }

    private static void checkTicksPerWheel(int ticksPerWheel) {
        if (!BitUtil.isPowerOfTwo(ticksPerWheel)) {
            throw new IllegalArgumentException("ticks per wheel must be a power of 2: " + ticksPerWheel);
        }
    }

    private static void checkResolution(long tickResolution) {
        if (!BitUtil.isPowerOfTwo(tickResolution)) {
            throw new IllegalArgumentException("tick resolution must be a power of 2: " + tickResolution);
        }
    }

    private static void checkInitialTickAllocation(int tickAllocation) {
        if (!BitUtil.isPowerOfTwo(tickAllocation)) {
            throw new IllegalArgumentException("tick allocation must be a power of 2: " + tickAllocation);
        }
    }

    @FunctionalInterface
    public static interface TimerConsumer {
        public void accept(long var1, long var3);
    }

    @FunctionalInterface
    public static interface TimerHandler {
        public boolean onTimerExpiry(TimeUnit var1, long var2, long var4);
    }
}

