/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.vector;

import com.hazelcast.shaded.io.github.jbellis.jvector.util.RamUsageEstimator;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.ArraySliceByteSequence;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.types.ByteSequence;
import java.util.Arrays;

public final class ArrayByteSequence
implements ByteSequence<byte[]> {
    private final byte[] data;

    ArrayByteSequence(int length) {
        this.data = new byte[length];
    }

    ArrayByteSequence(byte[] data) {
        this.data = data;
    }

    @Override
    public byte[] get() {
        return this.data;
    }

    @Override
    public int offset() {
        return 0;
    }

    @Override
    public byte get(int n) {
        return this.data[n];
    }

    @Override
    public void set(int n, byte value) {
        this.data[n] = value;
    }

    @Override
    public void setLittleEndianShort(int shortIndex, short value) {
        this.data[shortIndex * 2] = (byte)(value & 0xFF);
        this.data[shortIndex * 2 + 1] = (byte)(value >> 8 & 0xFF);
    }

    @Override
    public void zero() {
        Arrays.fill(this.data, (byte)0);
    }

    @Override
    public int length() {
        return this.data.length;
    }

    public ArrayByteSequence copy() {
        return new ArrayByteSequence(Arrays.copyOf(this.data, this.data.length));
    }

    @Override
    public ByteSequence<byte[]> slice(int offset, int length) {
        if (offset == 0 && length == this.data.length) {
            return this;
        }
        return new ArraySliceByteSequence(this, offset, length);
    }

    @Override
    public long ramBytesUsed() {
        int OH_BYTES = RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
        return (long)OH_BYTES + RamUsageEstimator.sizeOf(this.data);
    }

    @Override
    public void copyFrom(ByteSequence<?> src, int srcOffset, int destOffset, int length) {
        ArrayByteSequence csrc = (ArrayByteSequence)src;
        System.arraycopy(csrc.data, srcOffset, this.data, destOffset, length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < Math.min(this.data.length, 25); ++i) {
            sb.append(this.data[i]);
            if (i >= this.data.length - 1) continue;
            sb.append(", ");
        }
        if (this.data.length > 25) {
            sb.append("...");
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        return this.equalTo(o);
    }

    public int hashCode() {
        return this.getHashCode();
    }
}

