/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.graph.similarity;

import com.hazelcast.shaded.io.github.jbellis.jvector.graph.RandomAccessVectorValues;
import com.hazelcast.shaded.io.github.jbellis.jvector.pq.PQVectors;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.types.VectorFloat;
import com.hazelcast.shaded.org.agrona.collections.Int2ObjectHashMap;

class CachingVectorValues
implements RandomAccessVectorValues {
    private final PQVectors cv;
    private final int dimension;
    private final Int2ObjectHashMap<VectorFloat<?>> cache;
    private final RandomAccessVectorValues ravv;

    public CachingVectorValues(PQVectors cv, int dimension, Int2ObjectHashMap<VectorFloat<?>> cache, RandomAccessVectorValues ravv) {
        this.cv = cv;
        this.dimension = dimension;
        this.cache = cache;
        this.ravv = ravv;
    }

    @Override
    public int size() {
        return this.cv.count();
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public boolean isValueShared() {
        return false;
    }

    @Override
    public RandomAccessVectorValues copy() {
        return this;
    }

    @Override
    public void getVectorInto(int nodeId, VectorFloat<?> result, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VectorFloat<?> getVector(int nodeId) {
        return this.cache.computeIfAbsent(nodeId, n -> {
            VectorFloat<?> v = this.ravv.getVector(n);
            return this.ravv.isValueShared() ? v.copy() : v;
        });
    }
}

