/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.graph.disk;

import com.hazelcast.shaded.io.github.jbellis.jvector.disk.RandomAccessReader;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.disk.CommonHeader;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.disk.Feature;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.disk.FeatureId;
import java.io.DataOutput;
import java.io.IOException;
import java.util.EnumMap;
import java.util.EnumSet;

class Header {
    final CommonHeader common;
    final EnumMap<FeatureId, ? extends Feature> features;

    Header(CommonHeader common, EnumMap<FeatureId, ? extends Feature> features) {
        this.common = common;
        this.features = features;
    }

    void write(DataOutput out) throws IOException {
        this.common.write(out);
        if (this.common.version >= 3) {
            out.writeInt(FeatureId.serialize(EnumSet.copyOf(this.features.keySet())));
        }
        for (Feature feature : this.features.values()) {
            feature.writeHeader(out);
        }
    }

    public int size() {
        int size = this.common.size();
        if (this.common.version >= 3) {
            size += 4;
        }
        return size += this.features.values().stream().mapToInt(Feature::headerSize).sum();
    }

    static Header load(RandomAccessReader reader, long offset) throws IOException {
        reader.seek(offset);
        EnumMap<FeatureId, Feature> features = new EnumMap<FeatureId, Feature>(FeatureId.class);
        CommonHeader common = CommonHeader.load(reader);
        EnumSet<FeatureId> featureIds = common.version >= 3 ? FeatureId.deserialize(reader.readInt()) : EnumSet.of(FeatureId.INLINE_VECTORS);
        for (FeatureId featureId : featureIds) {
            features.put(featureId, featureId.load(common, reader));
        }
        return new Header(common, features);
    }
}

