/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.graph.disk;

import com.hazelcast.shaded.io.github.jbellis.jvector.disk.RandomAccessReader;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.disk.CommonHeader;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.disk.Feature;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.disk.FusedADC;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.disk.InlineVectors;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.BiFunction;

public enum FeatureId {
    INLINE_VECTORS(InlineVectors::load),
    FUSED_ADC(FusedADC::load);

    public static final Set<FeatureId> ALL;
    private final BiFunction<CommonHeader, RandomAccessReader, Feature> loader;

    private FeatureId(BiFunction<CommonHeader, RandomAccessReader, Feature> loader) {
        this.loader = loader;
    }

    Feature load(CommonHeader header, RandomAccessReader reader) {
        return this.loader.apply(header, reader);
    }

    public static EnumSet<FeatureId> deserialize(int bitflags) {
        EnumSet<FeatureId> set = EnumSet.noneOf(FeatureId.class);
        for (int n = 0; n < FeatureId.values().length; ++n) {
            if ((bitflags & 1 << n) == 0) continue;
            set.add(FeatureId.values()[n]);
        }
        return set;
    }

    public static int serialize(EnumSet<FeatureId> flags) {
        int i = 0;
        for (FeatureId flag : flags) {
            i |= 1 << flag.ordinal();
        }
        return i;
    }

    static {
        ALL = Collections.unmodifiableSet(EnumSet.allOf(FeatureId.class));
    }
}

