/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.graph.disk;

import com.hazelcast.shaded.io.github.jbellis.jvector.disk.RandomAccessReader;
import java.io.DataOutput;
import java.io.IOException;

class CommonHeader {
    public final int version;
    public final int size;
    public final int dimension;
    public final int entryNode;
    public final int maxDegree;

    CommonHeader(int version, int size, int dimension, int entryNode, int maxDegree) {
        this.version = version;
        this.size = size;
        this.dimension = dimension;
        this.entryNode = entryNode;
        this.maxDegree = maxDegree;
    }

    void write(DataOutput out) throws IOException {
        if (this.version >= 3) {
            out.writeInt(-62111);
            out.writeInt(this.version);
        }
        out.writeInt(this.size);
        out.writeInt(this.dimension);
        out.writeInt(this.entryNode);
        out.writeInt(this.maxDegree);
    }

    static CommonHeader load(RandomAccessReader reader) throws IOException {
        int size;
        int version;
        int maybeMagic = reader.readInt();
        if (maybeMagic == -62111) {
            version = reader.readInt();
            size = reader.readInt();
        } else {
            version = 2;
            size = maybeMagic;
        }
        int dimension = reader.readInt();
        int entryNode = reader.readInt();
        int maxDegree = reader.readInt();
        return new CommonHeader(version, size, dimension, entryNode, maxDegree);
    }

    int size() {
        return ((this.version >= 3 ? 2 : 0) + 4) * 4;
    }
}

