/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.graph;

import com.hazelcast.shaded.io.github.jbellis.jvector.graph.NodeQueue;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.ArrayUtil;

public class NodesUnsorted {
    protected int size;
    float[] score;
    int[] node;

    public NodesUnsorted(int initialSize) {
        this.node = new int[initialSize];
        this.score = new float[initialSize];
    }

    public void add(int newNode, float newScore) {
        if (this.size == this.node.length) {
            this.growArrays();
        }
        this.node[this.size] = newNode;
        this.score[this.size] = newScore;
        ++this.size;
    }

    protected final void growArrays() {
        this.node = ArrayUtil.grow(this.node);
        this.score = ArrayUtil.growExact(this.score, this.node.length);
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public void foreach(NodeQueue.NodeConsumer consumer) {
        for (int i = 0; i < this.size; ++i) {
            consumer.accept(this.node[i], this.score[i]);
        }
    }

    public String toString() {
        return "NodesUnsorted[" + this.size + "]";
    }
}

