/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.disk;

import com.hazelcast.shaded.io.github.jbellis.jvector.disk.RandomAccessReader;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferReader
implements RandomAccessReader {
    protected final ByteBuffer bb;

    public ByteBufferReader(ByteBuffer sourceBB) {
        this.bb = sourceBB;
    }

    @Override
    public void seek(long offset) {
        this.bb.position(Math.toIntExact(offset));
    }

    @Override
    public long getPosition() {
        return this.bb.position();
    }

    @Override
    public void readFully(float[] buffer) {
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = this.bb.getFloat();
        }
    }

    @Override
    public void readFully(byte[] b) {
        this.bb.get(b);
    }

    @Override
    public void readFully(ByteBuffer buffer) {
        ByteBuffer slice = this.bb.slice();
        int remaining = buffer.remaining();
        slice.limit(remaining);
        buffer.put(slice);
        this.bb.position(this.bb.position() + remaining);
    }

    @Override
    public void readFully(long[] vector) {
        for (int i = 0; i < vector.length; ++i) {
            vector[i] = this.bb.getLong();
        }
    }

    @Override
    public int readInt() {
        return this.bb.getInt();
    }

    @Override
    public float readFloat() throws IOException {
        return this.bb.getFloat();
    }

    @Override
    public void read(int[] ints, int offset, int count) {
        for (int i = 0; i < count; ++i) {
            ints[offset + i] = this.bb.getInt();
        }
    }

    @Override
    public void read(float[] floats, int offset, int count) {
        for (int i = 0; i < count; ++i) {
            floats[offset + i] = this.bb.getFloat();
        }
    }

    @Override
    public void close() {
    }
}

